package com.ds.editor;

import com.ds.bpm.bpd.BPD;
import com.ds.common.JDSException;
import com.ds.common.swing.util.ImageUtil;
import com.ds.config.JDSConfig;
import com.ds.config.JDSUtil;
import com.ds.config.UserBean;
import com.ds.context.JDSActionContext;
import com.ds.editor.chrome.PageEditor;
import com.ds.editor.cmd.ESDChrome;
import com.ds.esb.config.manager.EsbBeanFactory;
import com.ds.esb.config.manager.ExpressionTempBean;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.esb.util.EsbFactory;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.PageHis;
import com.ds.esd.project.config.DevUserConfig;
import com.ds.jds.core.User;
import com.ds.login.JDSTrayIcon;
import com.ds.login.LoginPanel;
import com.ds.server.JDSServer;
import com.ds.server.httpproxy.ServerProxyFactory;
import com.ds.server.httpproxy.core.AbstractHandler;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.ProxyHost;
import org.openqa.selenium.WindowType;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;

import javax.swing.*;
import java.awt.*;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.*;
import java.util.*;
import java.util.List;


public class ESDEditor {

    public static final String PRODUCT_NAME = "ESD EditorTools";

    public static final String PRODUCT_VERSION = "V0.5b";

    public static final String PRODUCT_COPYRIGHT = "Copyright(c)2012 - 2021 itjds.net, All Rights Reserved";

    public static final String MAIN_URL = "http://itjds.net/projectManager/index.do";

    static ESDEditor esdEditor;

    private JDSTrayIcon ti;

    private ESDSplash splash;

    private LoginPanel loginPanel;

    private User user;

    public static final String THREAD_LOCK = "Thread Lock";


    public LinkedHashMap<String, PageEditor> pageEditorMap = new LinkedHashMap<>();


    public LinkedHashMap<String, PageEditor> handleEditorMap = new LinkedHashMap<>();


    public LinkedHashMap<String, List<String>> driverMap = new LinkedHashMap<>();

    public static ESDEditor getInstance() {
        if (esdEditor == null) {
            synchronized (THREAD_LOCK) {
                if (esdEditor == null) {
                    esdEditor = new ESDEditor();
                }
            }
        }
        return esdEditor;
    }

    ESDEditor() {
        this.ti = this.getTi();
    }


    private String getLocalPort() {
        ServerSocket s = null;
        String port = "8083";
        try {
            s = new ServerSocket(0);
            port = s.getLocalPort() + "";
            s.close();
        } catch (MalformedURLException e3) {
            e3.printStackTrace();
        } catch (IOException e3) {
            e3.printStackTrace();
        }
        return port;
    }


    public ChromeDriver getChromeDriverById(String handleId) {
        ChromeDriver chromeDriver = handleEditorMap.get(handleId);
        return chromeDriver;
    }

    public ChromeDriver getCurrChromeDriver() {
        ChromeDriver editor = null;
        HttpRequest request = (HttpRequest) JDSActionContext.getActionContext().getHttpRequest();
        if (request != null) {
            URL parenturl = null;
            try {
                parenturl = new URL(request.getHeaders().get(AbstractHandler.RefererHeard));
            } catch (MalformedURLException e) {
                e.printStackTrace();
            }
            editor = ESDEditor.getInstance().getChromeDriver(parenturl);
        }
        return editor;
    }


    public Map<String, PageEditor> getAllPage() {
        return handleEditorMap;
    }

    public PageEditor getMainDriver() {
        PageEditor pageEditor = pageEditorMap.get("itjds.net");
        return pageEditor;
    }

    public List<String> addHandleIds(URL url, String handleId) {
        PageEditor pageEditor = pageEditorMap.get(url.getHost());
        List<String> handles = driverMap.get(url.toString());
        if (handles == null) {
            handles = new ArrayList<>();
            driverMap.put(url.toString(), handles);
        }

        handles.add(handles.size(), handleId);
        return handles;
    }

    public ChromeDriver getChromeDriver(URL url) {
        ChromeDriver webDriver = null;
        PageEditor pageEditor = pageEditorMap.get(url.getHost());
        List<String> handles = driverMap.get(url.toString());
        if (handles != null && handles.size() > 0) {
            for (String handleId : handles) {
                if (handleId != null && pageEditor.getWindowHandles().contains(handleId)) {
                    webDriver = (ChromeDriver) pageEditor.switchTo().window(handleId);
                    continue;
                }
            }
        }
        return webDriver;

    }


    public void openCustomWin(String url, String sessionid) {
        ChromeOptions options = new ChromeOptions();
        options.setExperimentalOption("useAutomationExtension", false);
        options.setExperimentalOption("excludeSwitches", Collections.singletonList("enable-automation"));
        String proxyUrl = UserBean.getInstance().getProxyHost() + ":" + ServerProxyFactory.getInstance().getProxyServer().getPort();
        options.addArguments("--proxy-server=" + proxyUrl);
        if (sessionid == null) {
            try {
                sessionid = JDSServer.getInstance().getAdminUser().getSessionId();
            } catch (JDSException e) {
                e.printStackTrace();
            }
        }
        ChromeDriver pageEditor = new ChromeDriver(options);
        pageEditor.get(url);
    }

    public void openNOProxyWin(URL url, String path, String projectName, String sessionId) throws JDSException, IOException {
        ProxyHost proxyhost = null;
        DevUserConfig userConfig = ESDFacrory.getESDClient().getUserConfig();
        List<ProxyHost> proxyHosts = userConfig.getProxyHostByUrl(url.getHost());
        if (proxyHosts.isEmpty()) {
            proxyhost = ServerProxyFactory.getInstance().createProxy(url, projectName, null, null, null);
            if (sessionId != null) {
                proxyhost.setSessionId(sessionId);
            }
            userConfig.getHosts().add(proxyhost);
            ESDFacrory.getESDClient().updateUserConfig(userConfig);
        } else {
            proxyhost = proxyHosts.get(0);
            proxyhost = ServerProxyFactory.getInstance().createProxy(proxyhost);
        }

        if (sessionId == null) {
            sessionId = proxyhost.getSessionId();
        }

        if (sessionId == null) {
            sessionId = JDSServer.getInstance().getAdminUser().getSessionId();
        }

        URI uri = null;
        try {
            uri = new URI("http://" + proxyhost.getLocalIp() + ":" + proxyhost.getPort() + path);
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }

        Desktop.getDesktop().browse(uri);

    }

    public void openOtherWin(String url, String sessionid) {
        ChromeOptions options = new ChromeOptions();
        options.setExperimentalOption("useAutomationExtension", false);
        options.setExperimentalOption("excludeSwitches", Collections.singletonList("enable-automation"));
        ChromeDriver pageEditor = new ChromeDriver(options);
        pageEditor.get(url);
    }

    public void openNewWin(URL url, String sessionid) {

        PageEditor pageEditor = pageEditorMap.get(url.getHost());
        if (pageEditor == null) {
            ChromeOptions options = new ChromeOptions();
            options.setExperimentalOption("useAutomationExtension", false);
            options.setExperimentalOption("excludeSwitches", Collections.singletonList("enable-automation"));
            String proxyUrl = UserBean.getInstance().getProxyHost() + ":" + ServerProxyFactory.getInstance().getProxyServer().getPort();
            options.addArguments("--proxy-server=" + proxyUrl);
            if (sessionid == null) {
                try {
                    sessionid = JDSServer.getInstance().getAdminUser().getSessionId();
                } catch (JDSException e) {
                    e.printStackTrace();
                }
            }
            pageEditor = new PageEditor(options, url, sessionid);
            addHandleIds(url, pageEditor.getWindowHandle());
            ESDChrome esdChrome = new ESDChrome(pageEditor);
            esdChrome.screenPage(url, 10000);
            pageEditorMap.put(url.getHost(), pageEditor);

        } else {
            try {
                ChromeDriver webDriver = (ChromeDriver) pageEditor.switchTo().newWindow(WindowType.TAB);
                //  webDriver.manage().timeouts().implicitlyWait(Duration.ofMillis(2000));
                addHandleIds(url, webDriver.getWindowHandle());
                webDriver.navigate().to(url);
                ESDChrome esdChrome = new ESDChrome(pageEditor);
                esdChrome.screenPage(url, 10000);

            } catch (Throwable e) {
                e.printStackTrace();
                pageEditorMap.remove(url.getHost());
                driverMap.remove(url.toString());
                openUrl(url, sessionid);
            }
        }
        handleEditorMap.put(pageEditor.getWindowHandle(), pageEditor);
    }


    public void openUrl(URL url, String sessionid) {
        EsbFactory.initBus();
        List<? extends ServiceBean> list = EsbBeanFactory.getInstance().loadAllServiceBean();
        for (int k = 0; k < list.size(); k++) {
            if (!(list.get(k) instanceof ExpressionTempBean)) {
                continue;
            }
            ExpressionTempBean bean = (ExpressionTempBean) list.get(k);
            if (splash != null) {
                splash.showStatus("装载组件：" + bean.getName(), 50);
            }

        }
        ServerProxyFactory.getInstance();
        System.out.println("------------" + JDSConfig.getAbsolutePath("/") + "server.properties");
        System.out.println("************************************************");
        ChromeOptions options = new ChromeOptions();
        System.out.println("********************start proxy " + UserBean.getInstance().getProxyHost() + ":" + ServerProxyFactory.getInstance().getProxyServer().getPort());
        options.setExperimentalOption("useAutomationExtension", false);
        options.setExperimentalOption("excludeSwitches", Collections.singletonList("enable-automation"));
        String proxyUrl = UserBean.getInstance().getProxyHost() + ":" + ServerProxyFactory.getInstance().getProxyServer().getPort();
        options.addArguments("--proxy-server=" + proxyUrl);
        if (splash != null) {
            splash.showStatus("初始化浏览器环境", 80);
        }
        PageEditor pageEditor = new PageEditor(options, url, sessionid);
        pageEditorMap.put(url.getHost(), pageEditor);
        handleEditorMap.put(pageEditor.getWindowHandle(), pageEditor);
        List<PageHis> urls = ESDFacrory.getInstance().getUrls(this.getUser().getAccount());
        for (PageHis pageHis : urls) {
            if (!pageHis.getUrl().equals(url)) {
                try {
                    URL rUrl = new URL(pageHis.getUrl());
                    if (!rUrl.equals(url)) {

                        this.openNewWin(rUrl, null);
                    }
                } catch (MalformedURLException e) {
                    e.printStackTrace();
                }

            }

        }

    }

    public void closeAllPage() {
        Set<String> keys = this.getAllPage().keySet();
        for (String key : keys) {
            PageEditor editor = this.getAllPage().get(key);
            editor.quit();
        }
    }


    public static void main(String[] args) throws IOException {
        main(args, null, null);
    }


    public void login(boolean show, UserBean bean) throws JDSException {

        if (!show) {
            this.getLoginPanel().showLoginPanel(UserBean.getInstance(), false);

        } else {
            ESDEditor.getInstance().showSplash();
            if (this.loginPanel == null || !this.loginPanel.isVisible()) {
                splash.showStatus("开始认证用户", 20);
            }

            this.user = JDSServer.getClusterClient().getUDPClient().clientLogin(bean);
            if (this.loginPanel != null) {
                this.loginPanel.setVisible(false);
            }

            try {
                openUrl(new URL(MAIN_URL), JDSServer.getInstance().getAdminUser().getSessionId());
            } catch (MalformedURLException e) {
                e.printStackTrace();
            }
            this.hiddenSplash();


        }


    }

    public void openBPD() {
        BPD.getInstance().init(true);
        BPD.getInstance().autoLogin(user);
    }

    public void quit() {
        try {
            logout(false);
            ESDFacrory.getInstance().dumpCache();

            SystemTray tray = SystemTray.getSystemTray();
            tray.remove(ESDEditor.getInstance().getTi());
            System.exit(0);
        } catch (Throwable e) {
            System.exit(1);
        }

    }


    public void logout(Boolean show) {
        this.user = null;
        this.closeAllPage();
        ESDFacrory.getInstance().dumpCache();
        ServerProxyFactory.getInstance().shutdown();
        if (show) {
            this.getLoginPanel().showLoginPanel(UserBean.getInstance(), true);
        }
    }


    public void showSplash() {
        Icon icon = ImageUtil.getImg("splash.png");
        if (this.splash == null) {
            this.splash = new ESDSplash(icon, "正在初始化...", "启动ESD编辑器");

        }
        splash.show();
        splash.setVisible(true);
        // splash.showStatus("开始装载应用", 4);


    }


    public void hiddenSplash() {
        if (splash != null) {
            splash.showStatus("启动完毕", 100);
            splash.setVisible(false);
            splash = null;
        }


    }


    public static int main(String[] args, InputStream in, PrintStream out) {
        System.out.println("************************************************");
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable() {
            @Override
            public void run() {
                SystemTray tray = SystemTray.getSystemTray();
                tray.remove(ESDEditor.getInstance().getTi());
                ESDEditor.getInstance().closeAllPage();

            }
        }));

        try {
            System.setProperty("JDSHome", new File(JDSUtil.getJdsRealPath(), "JDSHome").getAbsolutePath());
            System.out.println("************************************************");
            System.out.println("----- 欢迎使用 JDS ESD 开发工具");
            System.out.println(PRODUCT_NAME + " - " + PRODUCT_VERSION);
            System.out.println(PRODUCT_COPYRIGHT);
            System.out.println("************************************************");
            System.out.println("-------- ESDTools Initialization ---------");
            System.out.println("************************************************");
            System.out.println("- Start Connect Server - " + UserBean.getInstance().getServerUrl() + "*");
            System.out.println("- Connent JDSServer UserName    [" + UserBean.getInstance().getUsername() + "]*");
            ESDEditor.getInstance().login(false, UserBean.getInstance());
        } catch (Exception e1) {
            e1.printStackTrace();
            return -1;
        }
        return 0;

    }


    public JDSTrayIcon getTi() {

        if (ti == null) {
            try {
                SystemTray tray = SystemTray.getSystemTray();
                TrayIcon[] tis = tray.getTrayIcons();
                for (TrayIcon oti : tis) {
                    if (oti.getImage().equals(ImageUtil.getCoolweiImg())) {
                        tray.remove(oti);
                    }
                }

                this.ti = new JDSTrayIcon();

                tray.add(this.ti);

            } catch (Throwable e1) {
                e1.printStackTrace();
                //e1.printStackTrace();
            }

        }

        return ti;
    }


    public User getUser() {
        return user;
    }


    public void setUser(User user) {
        this.user = user;
    }


    public LoginPanel getLoginPanel() {

        if (loginPanel == null) {
            loginPanel = new LoginPanel(UserBean.getInstance());
        }

        return loginPanel;
    }


    public void setLoginPanel(LoginPanel loginPanel) {
        this.loginPanel = loginPanel;
    }
}
