package com.ds.common.swing.table;

import java.util.Comparator;

/**
 * Interface Of a colimn in a TableViewModel
 *
 * @author St閜hane Brunner, Last modified by: $Author: wenzhangli $ 
 * @version $Revision: 1.1 $ $Date: 2013/05/28 12:16:32 $.
 * Revision history:
 * $Log: TableViewColumn.java,v $
 * Revision 1.1  2013/05/28 12:16:32  wenzhangli
 * v5.0
 * Committed on the Free edition of March Hare Software CVSNT Server.
 * Upgrade to CVS Suite for more features and support:
 * http://march-hare.com/cvsnt/
 *
 * Revision 1.1  2012/06/07 07:42:42  lwz
 * *** empty log message ***
 *
 * Revision 1.1  2011/06/09 14:42:36  administrator
 * *** empty log message ***
 *
 * Revision 1.2  2010/04/20 07:08:45  liwengzhang
 * *** empty log message ***
 *
 * Revision 1.1  2009/10/20 07:20:17  administrator
 * v3.0
 *
 * Revision 1.1  2009/08/04 09:45:15  administrator
 * *** empty log message ***
 *
 * Revision 1.1  2009/03/20 10:54:11  administrator
 * *** empty log message ***
 *
 * Revision 1.1  2008/12/24 07:55:04  administrator
 * *** empty log message ***
 *
 * Revision 1.1  2003/12/26 03:38:52  andy
 * no message
 *
 * Revision 1.8  2003/06/06 06:31:32  stbrunner
 * Change description
 *
 */
public interface TableViewColumn {
  /**
   * Returns the number of columns in the model. A
   * <code>JTable</code> uses this method to determine how many columns it
   * should create and display by default.
   *
   * @return the number of columns in the model
   * @see #getRowCount
   */
  public Comparator getComparator();

  /**
   * Returns the name of the column. This is used
   * to initialize the table's column header name.  Note: this name does
   * not need to be unique; two columns in a table can have the same name.
   *
   * @return  the name of the column
   */
  public String getName();

  /**
   * Returns the most specific superclass for all the cell values
   * in the column.  This is used by the <code>JTable</code> to set up a
   * default renderer and editor for the column.
   *
   * @return the common ancestor class of the object values in the model.
   */
  public Class getColumnClass();

  /**
   * Returns true if the cell is editable.
   * Otherwise, <code>setValueAt</code> on the cell will not
   * change the value of that cell.
   *
   * @param pRowObject the row whose value to be queried
   * @return true if the cell is editable
   * @see #setValueAt
   */
  public boolean isCellEditable(Object pRowObject);

  /**
   * Returns the value for the cell.
   *
   * @param pRowObject the row whose value is to be queried
   * @return the value Object at the specified cell
   */
  public Object getValue(Object pRowObject);

  /**
   * Sets the value in the cell to <code>aValue</code>.
   *
   * @param pValue the new value
   * @param pRowObject the row whose value is to be changed
   * @see #getValueAt
   * @see #isCellEditable
   */
  public void setValue(Object pValue, Object pRowObject);

  /**
   * Return the sortable status.
   *
   * @return true if it is sortable
   */
  public boolean isSortable();

  /**
   * Return the searchable status.
   *
   * @return true if it is searchable
   */
  public boolean isSearchable();

  /**
   * Return the default visibility status
   *
   * @return truen if it is visible as default
   */
  public boolean isDefaultVisible();
}
