/*
 * Created on 2005-12-23
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2005 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.panels.formula.org;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.misc.OrgTree;
import com.ds.bpm.bpd.misc.OrgTreeNode;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.common.JDSException;
import com.ds.org.Org;
import com.ds.org.OrgManager;
import com.ds.org.Person;
import com.ds.server.JDSServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.SubSystem;

import javax.swing.*;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;
import java.awt.*;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 组织机构显示页面
 * </p>
 * <p>
 * Copyright: Copyright (c) 2005
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2005-12-23 15:56:33
 * @version 1.0
 */

public class XMLRightOrgPanel extends XMLPanel {

	private static Dimension minimalDimension = new Dimension(120, 100);

	private static Dimension listDimension = new Dimension(120, 160);

	private List elements = new ArrayList();

	private int selectionModel;

	private JList allPersonList = new JList();

	private XMLCollection parent;

	// 构造器----不显示原有信息
	public XMLRightOrgPanel(XMLElement myOwner, String title,
			boolean hasBorder, boolean minDimension, int selectionModel) {
		this(myOwner, null, title, hasBorder, minDimension, selectionModel);
	}

	// 构造器----显示原有信息
	public XMLRightOrgPanel(XMLElement myOwner, XMLCollection parent,
			String title, boolean hasBorder, boolean minDimension,
			int selectionModel) {

		super(myOwner, 2, title, XMLPanel.BOX_LAYOUT, false, hasBorder);
		this.selectionModel = selectionModel;
		this.parent = parent;

		// 调用Org接口得到服务器的组织机构
		JPanel jPanel = new JPanel();
		jPanel.setLayout(new BorderLayout());



		WorkflowProcess wp = (WorkflowProcess) BPD.getInstance()
				.getActivedProcessEditor().getGraph().getPropertyObject();
		SubSystem system= null;
		try {
			system = JDSServer.getClusterClient().getSystem(JDSServer.getInstance().getCurrServerBean().getId());
		} catch (JDSException e) {
			e.printStackTrace();
		}
		OrgManager manager = OrgManagerFactory.getClientOrgManager(system.getConfigname());
		// 取得第一层的组织机构。
	

		OrgTree orgTree = new OrgTree(manager.getTopOrgs(system.getSysId()));
		JTree allOrgTree = new JTree(orgTree.getRoot());

		allOrgTree.setRootVisible(false);
		JPanel leftPanel = new JPanel();
		leftPanel.setLayout(new BorderLayout());
		JScrollPane orgScrollPane = new JScrollPane();
		orgScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
		orgScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
		orgScrollPane.setViewportView(allOrgTree);
		orgScrollPane.setPreferredSize(new Dimension(180, 200));
		allOrgTree.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent me) {
				JTree tree = (JTree) me.getSource();
				TreePath selPath = tree.getSelectionPath();
				if (selPath != null) {
					OrgTreeNode node = (OrgTreeNode) selPath
							.getLastPathComponent();
					Org org = (Org) node.getUserObject();
					if (org != null) {
						// 动态增加子节点。
						if (node.getChildren().length == 0) {
						    List<Org> childrens = org.getChildrenList();
							for (Org corg:childrens) {
								node.insert(new OrgTreeNode(corg));
							}
						}
						allPersonList.setListData(org.getPersonList().toArray());
					}
				}
			}
		});
		allOrgTree.addTreeWillExpandListener(new TreeWillExpandListener() {
			public void treeWillExpand(TreeExpansionEvent tee) {
				TreePath selPath = tee.getPath();
				if (selPath != null) {
					OrgTreeNode node = (OrgTreeNode) selPath
							.getLastPathComponent();
					Org org = (Org) node.getUserObject();
					if (org != null) {
						// 动态增加子节点。
						if (node.getChildren().length == 0) {
						    List<Org> childrens = org.getChildrenList();
						    for (Org corg : childrens) {
							node.insert(new OrgTreeNode(corg));
						    }
						}
						allPersonList.setListData(org.getPersonList().toArray());
					}
				}
			}

			public void treeWillCollapse(TreeExpansionEvent tee) {

			}
		});
		leftPanel.add(orgScrollPane, BorderLayout.CENTER);
		JPanel rightPanel = new JPanel();
		rightPanel.setLayout(new BorderLayout());
		JScrollPane personScrollPane = new JScrollPane();
		personScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
		personScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
		personScrollPane.setViewportView(allPersonList);
		personScrollPane.setPreferredSize(new Dimension(110, 200));
		rightPanel.add(personScrollPane, BorderLayout.CENTER);
		JPanel centerPanel = new JPanel();
		centerPanel.setPreferredSize(new Dimension(10, 200));
		jPanel.add(leftPanel, BorderLayout.WEST);
		jPanel.add(new JLabel(""), BorderLayout.CENTER);
		jPanel.add(rightPanel, BorderLayout.EAST);

		if (parent != null) {
			// 该工作流已配置的组织机构
			Collection selectedCollection = parent.toCollection();
			for (Iterator it = selectedCollection.iterator(); it.hasNext();) {
				XMLElement elem = (XMLElement) it.next();
				if (!elements.contains(elem.toValue())) {
					elements.add(elem.toValue());
				}
			}
		}

		final DefaultListModel listModel = new DefaultListModel();

		// fills list
		Iterator it = elements.iterator();

		while (it.hasNext()) {
			XMLElement elem = (XMLElement) it.next();
			listModel.addElement(elem);
		}
		allPersonList.setModel(listModel);
		allPersonList.setSelectionMode(selectionModel);

		allPersonList.setAlignmentX(Component.LEFT_ALIGNMENT);
		allPersonList.setAlignmentY(Component.TOP_ALIGNMENT);

		/*
		 * allPersonList.setToolTipText(
		 * ResourceManager.getLanguageDependentString(
		 * "Process.Right.Responsible.tooltip"));
		 */
		jPanel.setPreferredSize(new Dimension(300, 300));
		add(jPanel);
	}

	public void setElements() {
		Object[] objs = getList().getSelectedValues();
		if (objs == null || objs.length == 0) {
			return;
		}
		Object obj = objs[0];
		if (obj instanceof Person) {
			Person person = (Person) (obj);
			obj = new XMLSelectOption(person.getName(), person.getID());
		}
		getOwner().setValue(obj);
		if (objs.length > 1) {
			for (int i = 1; i < objs.length; i++) {
				if (objs[i] instanceof Person) {
					Person person = (Person) objs[i];
					Object val = new XMLSelectOption(person.getName(), person
							.getID());
					if (!parent.getValues().contains(val)) {
						XMLElement elem = parent.generateNewElement();
						elem.setValue(val);
						parent.add(elem);
						parent.onElementInserted(elem);
						JList l = parent.getJList();
						DefaultListModel model = (DefaultListModel) l
								.getModel();
						model.addElement(elem);
						l.setSelectedIndex(model.size());
					}
				}
			}
		}
	}

	public JList getList() {
		return allPersonList;
	}

	public boolean checkRequired() {
		if (getList().getSelectedIndex() == -1) {
			XMLPanel
					.errorMessage(
							this.getDialog(),
							ResourceManager
									.getLanguageDependentString("Sys.ErrorDialog.title"),
							getOwner().toLabel()
									+ ResourceManager
											.getLanguageDependentString("Sys.Colon"),
							ResourceManager
									.getLanguageDependentString("Sys.ListPanel.notSelect"));
			return false;
		}
		return true;
	}

	public int getSelectionModel() {
		return selectionModel;
	}
}
