/*
 * Created on 2004-4-6
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.panels.formula.org;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.formula.FormulaParameter;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.common.JDSException;
import com.ds.org.OrgManager;
import com.ds.org.Role;
import com.ds.server.JDSServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.SubSystem;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 选择人员工作组的面板类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-4-6 17:42:56
 * @version 1.0
 */
public class XMLPersonGroupPanel extends XMLPanel {

	private static Dimension minimalDimension = new Dimension(120, 100);

	private static Dimension listDimension = new Dimension(120, 160);

	private List elements = new ArrayList();

	private int selectionMode;

	// 备选人员工作组List
	JList allPersonGroupList = new JList();

	// 已选List
	private JList choosenList = new JList();

	// 构造器----显示原有信息
	public XMLPersonGroupPanel(XMLElement myOwner, String title,
			boolean hasBorder, boolean minDimension, int selectionMode) {

		super(myOwner, 2, title, XMLPanel.BOX_LAYOUT, false, hasBorder);
		this.selectionMode = selectionMode;

		// 调用Org接口得到服务器的人员工作组列表
		JPanel jPanel = new JPanel();
		jPanel.setLayout(new BorderLayout());



		WorkflowProcess wp = (WorkflowProcess) BPD.getInstance()
				.getActivedProcessEditor().getGraph().getPropertyObject();
		SubSystem system= null;
		try {
			system = JDSServer.getClusterClient().getSystem(JDSServer.getInstance().getCurrServerBean().getId());
		} catch (JDSException e) {
			e.printStackTrace();
		}
		OrgManager manager = OrgManagerFactory.getClientOrgManager(system.getConfigname());
		// 取得第一层的组织机构。
		Role[] personGroups = (Role[]) manager.getPersonGroups(system.getSysId()).toArray(new Role[]{});
		allPersonGroupList.setListData(personGroups);
		JPanel leftPanel = new JPanel();
		leftPanel.setLayout(new BorderLayout());
		JScrollPane orgScrollPane = new JScrollPane();
		orgScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
		orgScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
		orgScrollPane.setViewportView(allPersonGroupList);
		orgScrollPane.setPreferredSize(new Dimension(180, 200));
		allPersonGroupList.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent me) {
				if (me.getClickCount() > 1) {
					addOperation();
				}
			}
		});
		allPersonGroupList.setSelectionMode(selectionMode);
		leftPanel
				.add(
						new JLabel(
								"■ "
										+ ResourceManager
												.getLanguageDependentString("OrgRight.PersonWorkGroup.display")),
						BorderLayout.NORTH);
		leftPanel.add(orgScrollPane, BorderLayout.CENTER);
		JPanel orgPanel = new JPanel();
		orgPanel.setLayout(new BorderLayout());
		orgPanel.setPreferredSize(new Dimension(182, 250));
		orgPanel.add(leftPanel, BorderLayout.CENTER);

		// 该工作流已配置的组织机构
		if (myOwner.toValue() != null
				&& !myOwner.toValue().toString().equals("")) {
			String val = myOwner.toValue().toString();
			String[] vals = Utils.tokenize(val,
					FormulaParameter.DELIMITER_MULTIPLE);
			for (int i = 0; i < vals.length; i++) {
				String personGroup_name = vals[i];
				if (!personGroup_name.trim().equals("")) {
					elements.add(personGroup_name);
				}
			}
		}

		final DefaultListModel listModel = new DefaultListModel();

		// fills list
		Iterator it = elements.iterator();

		while (it.hasNext()) {
			listModel.addElement(it.next());
		}

		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new FlowLayout());
		String a = ResourceManager.getLanguageDependentString("AddKey");
		String r = ResourceManager.getLanguageDependentString("RemoveKey");
		Dimension dim = new Dimension(45, 15);
		XMLButton buttonAdd = new XMLButton(a, "AddSmall", dim);
		XMLButton buttonRemove = new XMLButton(r, "RemoveSmall", dim);
		// 添加按钮的操作
		buttonAdd.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				addOperation();
			}
		});
		// 删除按钮的操作
		buttonRemove.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				removeOperation();
			}
		});
		buttonPanel.add(new JLabel(" "));
		buttonPanel.add(buttonAdd);
		buttonPanel.add(new JLabel(" "));
		buttonPanel.add(buttonRemove);
		buttonPanel.setPreferredSize(new Dimension(80, 60));

		JPanel choosenPanel = new JPanel();
		choosenPanel.setLayout(new BorderLayout());
		JScrollPane choosenScrollPane = new JScrollPane();
		choosenScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
		choosenScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
		choosenScrollPane.setViewportView(choosenList);
		choosenList.setModel(listModel);
		choosenList.setSelectionMode(selectionMode);
		choosenScrollPane.setPreferredSize(new Dimension(110, 200));
		choosenPanel
				.add(
						new JLabel(
								"■ "
										+ ResourceManager
												.getLanguageDependentString("OrgRight.Choosen.display")),
						BorderLayout.NORTH);
		choosenPanel.add(choosenScrollPane, BorderLayout.CENTER);

		jPanel.add(orgPanel, BorderLayout.WEST);
		jPanel.add(buttonPanel, BorderLayout.CENTER);
		jPanel.add(choosenPanel, BorderLayout.EAST);
		add(jPanel);
	}

	public void setElements() {
		DefaultListModel model = (DefaultListModel) getList().getModel();
		String val = "";
		for (int i = 0; i < model.size(); i++) {
			Object obj = model.get(i);
			val = val + FormulaParameter.DELIMITER_MULTIPLE + obj;
		}
		if (!val.equals("")) {
			val = val.substring(FormulaParameter.DELIMITER_MULTIPLE.length());
		}
		getOwner().setValue(val);
	}

	public JList getList() {
		return choosenList;
	}

	public boolean checkRequired() {
		if (getList().getModel().getSize() == 0) {
			XMLPanel
					.errorMessage(
							this.getDialog(),
							ResourceManager
									.getLanguageDependentString("Sys.ErrorDialog.title"),
							getOwner().toLabel()
									+ ResourceManager
											.getLanguageDependentString("Sys.Colon"),
							ResourceManager
									.getLanguageDependentString("RightFormula.Parameter.notEmptyMessage"));
			return false;
		}
		return true;
	}

	public int getSelectionMode() {
		return selectionMode;
	}

	// 添加操作
	private void addOperation() {
		Object[] objs = allPersonGroupList.getSelectedValues();
		if (objs != null && objs.length > 0) {
			DefaultListModel model = (DefaultListModel) choosenList.getModel();
			if (getSelectionMode() == ListSelectionModel.SINGLE_SELECTION) {
				model.removeAllElements();
			}
			for (int i = 0; i < objs.length; i++) {
				Object obj = objs[i];
				if (obj instanceof Role) {
					String elem = ((Role) obj).getName();
					if (!model.contains(elem)) {
						model.addElement(elem);
					}
				}
			}
		}
	}

	// 删除操作
	private void removeOperation() {
		Object[] objs = choosenList.getSelectedValues();
		if (objs != null && objs.length > 0) {
			DefaultListModel model = (DefaultListModel) choosenList.getModel();
			for (int i = 0; i < objs.length; i++) {
				Object obj = objs[i];
				model.removeElement(obj);
			}
			if (model.size() > 0) {
				choosenList.setSelectedIndex(model.size() - 1);
			}
		}
	}
}
