
package com.ds.bpm.bpd.xml.panels.formula.database;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.misc.OrgTreeNode;
import com.ds.bpm.bpd.misc.TableTree;
import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.formula.FormulaParameter;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.common.JDSException;
import com.ds.common.database.dao.DAOException;
import com.ds.common.database.metadata.ColInfo;
import com.ds.common.database.metadata.MetadataFactory;
import com.ds.common.database.metadata.TableInfo;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;

import javax.swing.*;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XMLDBFieldPanel extends XMLPanel {
    private static Dimension minimalDimension = new Dimension(120, 100);

    private static Dimension listDimension = new Dimension(120, 160);
    private MetadataFactory factory;
    private List elements = new ArrayList();
    private int selectionMode;
    private ESDClient client;
    // 可选List
    private JList colinfoList = new JList();
    // 已选List
    private JList choosenList = new JList();

    public List<ColInfo> getTableInfos(TableInfo tableInfo) {
        List<ColInfo> colList = tableInfo.getColList();
        if (colList == null || colList.isEmpty()) {
            MetadataFactory metafactory = MetadataFactory.getInstance(tableInfo.getUrl());
            try {
                colList = metafactory.getTableInfo(tableInfo.getName()).getColList();
            } catch (DAOException e) {
                e.printStackTrace();
            }
        }
        return colList;
    }

    // 构造器----显示原有信息
    public XMLDBFieldPanel(XMLElement myOwner, String title, boolean hasBorder, boolean minDimension, int selectionMode) throws JDSException {
        super(myOwner, 2, title, XMLPanel.BOX_LAYOUT, false, hasBorder);
        this.selectionMode = selectionMode;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        WorkflowProcess wp = (WorkflowProcess) BPD.getInstance()
                .getActivedProcessEditor().getGraph().getPropertyObject();

        this.client = ESDFacrory.getESDClient();
        Project project = this.client.getProjectByName(wp.getProjectName());
        List<TableInfo> tableInfos = project.getTables();
        TableTree tableTree = new TableTree(tableInfos);
        JTree allTableTree = new JTree(tableTree.getRoot());

        allTableTree.setRootVisible(false);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        JScrollPane placeScrollPane = new JScrollPane();
        placeScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        placeScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
        placeScrollPane.setViewportView(allTableTree);
        placeScrollPane.setPreferredSize(new Dimension(180, 200));
        allTableTree.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent me) {
                JTree tree = (JTree) me.getSource();
                TreePath selPath = tree.getSelectionPath();
                if (selPath != null) {
                    OrgTreeNode node = (OrgTreeNode) selPath.getLastPathComponent();
                    TableInfo tableInfo = (TableInfo) node.getUserObject();
                    if (tableInfo != null) {
                        List<ColInfo> colList = getTableInfos(tableInfo);
                        if (node.getChildren().length == 0) {

                            for (ColInfo colInfo : colList) {
                                node.insert(new OrgTreeNode(colInfo));
                            }
                        }
                        colinfoList.setListData(colList.toArray());
                    }
                }
            }
        });
        allTableTree.addTreeWillExpandListener(new TreeWillExpandListener() {
            public void treeWillExpand(TreeExpansionEvent tee) {
                TreePath selPath = tee.getPath();
                if (selPath != null) {
                    OrgTreeNode node = (OrgTreeNode) selPath.getLastPathComponent();
                    TableInfo tableInfo = (TableInfo) node.getUserObject();
                    if (tableInfo != null) {
                        List<ColInfo> colList = getTableInfos(tableInfo);
                        if (node.getChildren().length == 0) {

                            for (ColInfo colInfo : colList) {
                                node.insert(new OrgTreeNode(colInfo));
                            }
                        }
                        colinfoList.setListData(colList.toArray());
                    }
                }
            }

            public void treeWillCollapse(TreeExpansionEvent tee) {

            }
        });
        leftPanel.add(new JLabel("■ " + "库表"), BorderLayout.NORTH);
        leftPanel.add(placeScrollPane, BorderLayout.CENTER);
        leftPanel.add(new JLabel(" "), BorderLayout.EAST);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        JScrollPane areaScrollPane = new JScrollPane();
        areaScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        areaScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
        areaScrollPane.setViewportView(colinfoList);
        areaScrollPane.setPreferredSize(new Dimension(110, 200));
        rightPanel.add(new JLabel("■ " + "字段"), BorderLayout.NORTH);
        rightPanel.add(areaScrollPane, BorderLayout.CENTER);
        JPanel placePanel = new JPanel();
        placePanel.setLayout(new BorderLayout());
        placePanel.setPreferredSize(new Dimension(292, 250));
        placePanel.add(leftPanel, BorderLayout.CENTER);
        placePanel.add(rightPanel, BorderLayout.EAST);

        if (myOwner.toValue() != null && !myOwner.toValue().toString().equals("")) {
            String val = myOwner.toValue().toString();
            String[] vals = Utils.tokenize(val, FormulaParameter.DELIMITER_MULTIPLE);
            for (int i = 0; i < vals.length; i++) {
                String colid = vals[i];
                if (!colid.trim().equals("") && colid.indexOf("##") > 0) {
                    String colCnname = null;
                    try {
                        String tableName = colid.split("##")[0];
                        String colname = colid.split("##")[1];
                        TableInfo tableInfo = ESDFacrory.getESDClient().getDbFactory("fdt").getTableInfo(tableName);
                        colCnname = tableInfo.getCoInfoByName(colname).getCnname();
                        if (colCnname != null) {
                            elements.add(new XMLSelectOption(colCnname, colname));
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }


                }
            }
        }

        final DefaultListModel listModel = new DefaultListModel();

        // fills list
        Iterator it = elements.iterator();

        while (it.hasNext()) {
            XMLElement elem = (XMLElement) it.next();
            listModel.addElement(elem);
        }
        // allPersonList.setModel(listModel);
        colinfoList.addMouseListener(new MouseAdapter() {
            public void mousePressed(MouseEvent me) {
                if (me.getClickCount() > 1) {
                    addOperation();
                }
            }
        });
        colinfoList.setSelectionMode(selectionMode);
        colinfoList.setAlignmentX(Component.LEFT_ALIGNMENT);
        colinfoList.setAlignmentY(Component.TOP_ALIGNMENT);

        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        String a = ResourceManager.getLanguageDependentString("AddKey");
        String r = ResourceManager.getLanguageDependentString("RemoveKey");
        Dimension dim = new Dimension(45, 15);
        XMLButton buttonAdd = new XMLButton(a, "AddSmall", dim);
        XMLButton buttonRemove = new XMLButton(r, "RemoveSmall", dim);
        // 添加按钮的操作
        buttonAdd.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                addOperation();
            }
        });
        // 删除按钮的操作
        buttonRemove.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                removeOperation();
            }
        });
        buttonPanel.add(new JLabel(" "));
        buttonPanel.add(buttonAdd);
        buttonPanel.add(new JLabel(" "));
        buttonPanel.add(buttonRemove);
        buttonPanel.setPreferredSize(new Dimension(80, 60));

        JPanel choosenPanel = new JPanel();
        choosenPanel.setLayout(new BorderLayout());
        JScrollPane choosenScrollPane = new JScrollPane();
        choosenScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        choosenScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
        choosenScrollPane.setViewportView(choosenList);
        choosenList.setModel(listModel);
        choosenList.setSelectionMode(selectionMode);
        choosenScrollPane.setPreferredSize(new Dimension(110, 200));
        choosenPanel.add(new JLabel("■ " + "已选字段"), BorderLayout.NORTH);
        choosenPanel.add(choosenScrollPane, BorderLayout.CENTER);

        jPanel.add(placePanel, BorderLayout.WEST);
        jPanel.add(buttonPanel, BorderLayout.CENTER);
        jPanel.add(choosenPanel, BorderLayout.EAST);
        add(jPanel);
    }

    public void setElements() {
        DefaultListModel model = (DefaultListModel) getList().getModel();
        String val = "";
        for (int i = 0; i < model.size(); i++) {
            Object obj = model.get(i);
            if (obj instanceof ColInfo) {
                ColInfo colInfo = (ColInfo) (obj);
                obj = new XMLSelectOption(colInfo.getCnname(), colInfo.getName());
            }
            val = val + FormulaParameter.DELIMITER_MULTIPLE + ((XMLSelectOption) obj).getText();
        }
        if (!val.equals("")) {
            val = val.substring(FormulaParameter.DELIMITER_MULTIPLE.length());
        }
        getOwner().setValue(val);
    }

    public JList getList() {
        return choosenList;
    }

    public boolean checkRequired() {
        if (getList().getModel().getSize() == 0) {
            XMLPanel.errorMessage(this.getDialog(), ResourceManager.getLanguageDependentString("Sys.ErrorDialog.title"), getOwner().toLabel() + ResourceManager.getLanguageDependentString("Sys.Colon"),
                    ResourceManager.getLanguageDependentString("RightFormula.Parameter.notEmptyMessage"));
            return false;
        }
        return true;
    }

    public int getSelectionMode() {
        return selectionMode;
    }

    // 添加操作
    private void addOperation() {
        Object[] objs = colinfoList.getSelectedValues();
        if (objs != null && objs.length > 0) {
            DefaultListModel model = (DefaultListModel) choosenList.getModel();
            for (int i = 0; i < objs.length; i++) {
                Object obj = objs[i];
                if (obj instanceof ColInfo) {
                    ColInfo colobj = (ColInfo) obj;
                    XMLSelectOption elem = new XMLSelectOption(colobj.getCnname(), colobj.getTablename() + "##" + colobj.getName());
                    if (!model.contains(elem)) {
                        model.addElement(elem);
                    }
                }
            }
        }
    }

    // 删除操作
    private void removeOperation() {
        Object[] objs = choosenList.getSelectedValues();
        if (objs != null && objs.length > 0) {
            DefaultListModel model = (DefaultListModel) choosenList.getModel();
            for (int i = 0; i < objs.length; i++) {
                Object obj = objs[i];
                model.removeElement(obj);
            }
            if (model.size() > 0) {
                choosenList.setSelectedIndex(model.size() - 1);
            }
        }
    }
}
