/*
 * Created on 2004-2-25
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.panels.formula;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.formula.Formula;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 公式显示面板类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-2-25 20:43:26
 * @version 1.0
 */
public class XMLFormulaPanel extends XMLPanel {
	protected static Dimension miniTableDimension = new Dimension(300, 75);

	protected static Dimension smallTableDimension = new Dimension(300, 200);

	protected static Dimension mediumTableDimension = new Dimension(600, 200);

	protected static Dimension largeTableDimension = new Dimension(800, 200);

	private int selectionMode;

	private List elements = new ArrayList();
//	
//	
//
//	public XMLFormulaPanel(XMLElement myOwner, final String[][] choices,
//			String title, boolean hasBorder, boolean automaticWidth,
//			boolean miniDimension, int selectionMode) {
//		super(myOwner, 2, title, XMLPanel.BOX_LAYOUT, false, hasBorder);
//		this.selectionMode = selectionMode;
//		Formula Formula = (Formula) myOwner;
//	}
	
	public XMLFormulaPanel(XMLElement myOwner, final String[][] choices,
			String title, boolean hasBorder, boolean automaticWidth,
			boolean miniDimension, int selectionMode) {

		super(myOwner, 2, title, XMLPanel.BOX_LAYOUT, false, hasBorder);
		this.selectionMode = selectionMode;
		Formula Formula = (Formula) myOwner;
		final String[] columnNames = {
				ResourceManager
						.getLanguageDependentString("Formula.Id.display"),
				ResourceManager
						.getLanguageDependentString("Formula.Name.display"),
				ResourceManager
						.getLanguageDependentString("Formula.Value.display"),
				ResourceManager
						.getLanguageDependentString("Formula.Description.display") };
		int noOfVisibleColumns = columnNames.length;
		TableModel dataModel = new AbstractTableModel() {
			public int getColumnCount() {
				return columnNames.length;
			}

			public int getRowCount() {
				return choices.length;
			}

			public Object getValueAt(int row, int col) {
				return choices[row][col];
			}

			// The default implementations of these methods in
			// AbstractTableModel would work, but we can refine them.
			public String getColumnName(int column) {
				return columnNames[column];
			}

			public Class getColumnClass(int col) {
				return getValueAt(0, col).getClass();
			}

			public void setValueAt(Object aValue, int row, int column) {
				choices[row][column] = (String) aValue;
			}
		};

		JTable tableView = new JTable(dataModel);
		TableColumn tableColumn;

		tableView.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent me) {
				if (me.getClickCount() > 1
						&& getSelectionMode() == ListSelectionModel.SINGLE_SELECTION) {
					setElements();
					getDialog().dispose();
				}
			}
		});

		tableView.getInputMap(JComponent.WHEN_FOCUSED).put(
				KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0, false),
				"SaveElement");
		tableView.getActionMap().put("SaveElement", new AbstractAction() {
			public void actionPerformed(ActionEvent e) {
				setElements();
				getDialog().dispose();
			}
		});

		// 隐藏不显示的列
		int[] invisibleFields = Formula.getInvisibleTableFieldOrdinals();
		if (invisibleFields != null && invisibleFields.length > 0) {
			for (int i = 0; i < invisibleFields.length; i++) {
				tableColumn = tableView.getColumnModel().getColumn(
						invisibleFields[i]);
				tableColumn.setMinWidth(0);
				tableColumn.setMaxWidth(0);
				tableColumn.setPreferredWidth(0);
				tableColumn.setResizable(false);
			}
			noOfVisibleColumns = noOfVisibleColumns - invisibleFields.length;
		}

		// setting some table properties
		tableView.setColumnSelectionAllowed(false);
		tableView.setRowSelectionAllowed(true);
		tableView.setSelectionMode(selectionMode);
		tableView.getTableHeader().setReorderingAllowed(false);

		JScrollPane allItemsPane = new JScrollPane();
		allItemsPane.setViewportView(tableView);
		Dimension tDim;
		if (miniDimension) {
			tDim = new Dimension(miniTableDimension);
		} else if (noOfVisibleColumns <= 3) {
			tDim = new Dimension(smallTableDimension);
		} else if (noOfVisibleColumns <= 5) {
			tDim = new Dimension(mediumTableDimension);
		} else {
			tDim = new Dimension(largeTableDimension);
		}

		if (automaticWidth) {
			tDim.width = tableView.getPreferredScrollableViewportSize().width;
		}
		tableView.setPreferredScrollableViewportSize(new Dimension(tDim));
		add(allItemsPane);
		add(Box.createVerticalGlue());
	}

	public void setElements() {
		Object value = null;
		JTable table = getTable();
		if (getSelectionMode() == ListSelectionModel.SINGLE_SELECTION) {
			value = new String[6];
			((String[]) value)[0] = (String) table.getValueAt(table
					.getSelectedRow(), 0);
			((String[]) value)[1] = (String) table.getValueAt(table
					.getSelectedRow(), 1);
			((String[]) value)[2] = (String) table.getValueAt(table
					.getSelectedRow(), 2);
			((String[]) value)[3] = (String) table.getValueAt(table
					.getSelectedRow(), 3);
			((String[]) value)[4] = (String) table.getValueAt(table
					.getSelectedRow(), 1);
			((String[]) value)[5] = (String) table.getValueAt(table
					.getSelectedRow(), 3);
		}
		((Formula) getOwner()).saveValue(value);
	}

	public JTable getTable() {
		JScrollPane jsp = (JScrollPane) getComponent(0);
		JViewport jvp = (JViewport) jsp.getComponent(0);
		JTable t = (JTable) jvp.getComponent(0);
		return t;
	}

	public boolean checkRequired() {
		if (getTable().getSelectedRow() == -1) {
			XMLPanel
					.errorMessage(
							this.getDialog(),
							ResourceManager
									.getLanguageDependentString("Sys.ErrorDialog.title"),
							getOwner().toLabel()
									+ ResourceManager
											.getLanguageDependentString("Sys.Colon"),
							ResourceManager
									.getLanguageDependentString("Sys.TablePanel.notSelect"));
			return false;
		}
		return true;
	}

	public int getSelectionMode() {
		return selectionMode;
	}
}
