/*
 * Created on 2004-3-31
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.panels.formula;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.plugin.impl.activity.ActivityRight;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.elements.formula.Formula;
import com.ds.bpm.bpd.xml.panels.XMLTableControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLTablePanel;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 公式配置列表控制展示面板类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-3-31 17:26:54
 * @version 1.0
 */
public class XMLFormulaControlPanel extends XMLTableControlPanel {

	/**
	 * @param myOwner
	 * @param title
	 * @param isVertical
	 * @param hasBorder
	 */
	public XMLFormulaControlPanel(XMLCollection myOwner, String title,
			boolean isVertical, boolean hasBorder) {
		super(myOwner, title, isVertical, hasBorder);
	}

	protected void addPerform(ActionEvent ae) {
		if (BPD.getInstance().getUserInfo() == null) {
			return;
		}
		Formula newElement = (Formula) ((XMLCollection) getOwner())
				.generateNewElement();
		XMLElementDialog de = new XMLElementDialog(getDialog(), newElement
				.toLabel()
				+ " - "
				+ ResourceManager.getLanguageDependentString("DefiningKey"));
		de.editXMLElement(newElement.getPanel(), true, false);
		// if cancel hasn't been pressed
		if (!de.isCanceled()) {
			// 配置参数
			if (!newElement.configParameters(getDialog())) {
				return;
			}
			if (addElement((XMLCollectionElement) newElement)) {
				((XMLCollection) getOwner()).onElementCreated(newElement);
			}
		}
	}

	protected void editPerform(ActionEvent ae) {
		if (BPD.getInstance().getUserInfo() == null) {
			return;
		}
		Formula editElement = (Formula) getSelectedElement();
		if (editElement != null) {
			if (!editElement.configParameters(getDialog())) {
				return;
			}
			modifyElement(editElement);
			((XMLCollection) getOwner()).onElementModified(editElement);
		} else {
			complainLoudly("WarningEmptySelectionToEditOrDelete");
		}
		((XMLTablePanel) controlledPanel).getTable().requestFocus();
	}

	protected boolean addElement(XMLCollectionElement e) {
		Collection collection = ((XMLCollection) getOwner()).toCollection();
		((XMLCollection) getOwner()).add(e);
		JTable t = ((XMLTablePanel) controlledPanel).getTable();
		DefaultTableModel dtm = (DefaultTableModel) t.getModel();
		Vector v = new Vector(e.toComplexTypeValues());
		// add object itself to the first column (it is invisible column)
		v.add(0, e);
		dtm.addRow(v);
		try {
			t.setRowSelectionInterval(t.getRowCount() - 1, t.getRowCount() - 1);
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		t.requestFocus();
		return true;
	}

	// 控制相同的公式只能添加一次
	private boolean canAdd(XMLCollectionElement e) {
		Collection collection = ((XMLCollection) getOwner()).toCollection();
		boolean flag = true;
		for (Iterator it = collection.iterator(); it.hasNext();) {
			XMLCollectionElement tmp = (XMLCollectionElement) it.next();
			// 相同的公式只能添加一次
			if (tmp.getID().equals(e.getID())) {
				flag = false;
				break;
			}
			// 高级公式只能添加一次
			if (e.getID().startsWith(ActivityRight.CUSTOMFORMULA)
					&& tmp.getID().startsWith(ActivityRight.CUSTOMFORMULA)) {
				flag = false;
				break;
			}
		}
		return flag;
	}
}
