/*
 * Created on 2004-1-6
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.border.EtchedBorder;

import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLButtonAttribute;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.elements.formula.Formula;
import com.ds.bpm.bpd.xml.panels.formula.org.XMLRightOrgPanel;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 带选择Button和MulitLineText的Panel
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-1-6 11:02:06
 * @version 1.0
 * @deprecated
 */
public class XMLMultiLineTextButtonPanel extends XMLPanel {
	public static Dimension textAreaDimension = new Dimension(250, 20);

	public static Dimension miniTADimension = new Dimension(120, 20);

	private JButton jb;

	public XMLMultiLineTextButtonPanel(XMLElement myOwner) {
		this(myOwner, XMLPanel.BOX_LAYOUT);
	}

	public XMLMultiLineTextButtonPanel(XMLElement myOwner, boolean miniDimension) {
		this(myOwner, XMLPanel.BOX_LAYOUT, false, false, true, true);
	}

	public XMLMultiLineTextButtonPanel(XMLElement myOwner, int layout) {
		this(myOwner, layout, false, false, true, false);
	}

	public XMLMultiLineTextButtonPanel(XMLElement myOwner, int layout,
			boolean isVertical, boolean bigPanel, boolean wrapLines,
			boolean miniDimension) {

		super(myOwner, 3, "", layout, isVertical, false);

		JScrollPane jsp = new JScrollPane();
		jsp.setAlignmentX(Component.LEFT_ALIGNMENT);
		jsp.setAlignmentY(Component.TOP_ALIGNMENT);

		jb = new JButton(myOwner.toLabel()
				+ ResourceManager.getLanguageDependentString("Sys.Colon"));
		jb.setAlignmentX(Component.LEFT_ALIGNMENT);
		jb.setAlignmentY(Component.TOP_ALIGNMENT);
		jb.setHorizontalAlignment(SwingConstants.RIGHT);
		jb.setBorder(BorderFactory.createEmptyBorder());
		// 加入鼠标侦听事件
		jb.addMouseListener(new MouseAdapter() {
			// 鼠标移过事件
			public void mouseEntered(MouseEvent me) {
				jb.setBorder(BorderFactory
						.createEtchedBorder(EtchedBorder.LOWERED));
				jb.setToolTipText(((XMLButtonAttribute) getOwner())
						.getToolTipText());
			}

			// 鼠标离开事件
			public void mouseExited(MouseEvent me) {
				jb.setBorder(BorderFactory.createEmptyBorder());
			}

			// 鼠标按下事件
			public void mousePressed(MouseEvent me) {
				jb.setBorder(BorderFactory.createLoweredBevelBorder());
				doMousePressed();
			}
		});

		JTextArea jta = new JTextArea();

		jta.setTabSize(4);
		jta.setText(((Formula) myOwner).toString());
		jta.getCaret().setDot(0);
		jta.setLineWrap(wrapLines);
		jta.setWrapStyleWord(wrapLines);

		jta.setAlignmentX(Component.LEFT_ALIGNMENT);
		jta.setAlignmentY(Component.TOP_ALIGNMENT);

		jta.setEnabled(!myOwner.isReadOnly());
		jta.setFont(BPDConfig.getInstance().getFont());

		jsp.setViewportView(jta);
		jsp.setAlignmentX(Component.LEFT_ALIGNMENT);
		jsp.setAlignmentY(Component.TOP_ALIGNMENT);
		if (!bigPanel) {
			jsp.setPreferredSize(new Dimension(textAreaDimension));
		} else {
			jsp.setPreferredSize(new Dimension(400, 400));
		}
		if (miniDimension) {
			jsp.setPreferredSize(miniTADimension);
		}
		add(Box.createHorizontalGlue());
		add(jb);
		add(jsp);
		if (!((XMLButtonAttribute) getOwner()).isModified()) {
			setText(((XMLButtonAttribute) getOwner()).getOldValue());
		}
	}

	public boolean checkRequired() {
		if (isEmpty() && getOwner().isRequired() && !getOwner().isReadOnly()) {

			XMLPanel.defaultErrorMessage(this.getDialog(),
					((JLabel) getComponent(1)).getText());
			JScrollPane jsp = (JScrollPane) getComponent(2);
			JViewport jvp = (JViewport) jsp.getComponent(0);
			((JTextArea) jvp.getComponent(0)).requestFocus();
			return false;
		}
		return true;
	}

	public boolean isEmpty() {
		return getText().trim().equals("");
	}

	public void setElements() {
		if (!getText().equals(getOwner().toString())) {
			getOwner().setValue(getText());
		}
		((XMLButtonAttribute) getOwner()).setModified(true);
	}

	public String getText() {
		JScrollPane jsp = (JScrollPane) getComponent(2);
		JViewport jvp = (JViewport) jsp.getComponent(0);
		return ((JTextArea) jvp.getComponent(0)).getText();
	}

	public void setText(String value) {
		((XMLButtonAttribute) getOwner()).setOldValue(getText());
		JScrollPane jsp = (JScrollPane) getComponent(2);
		JViewport jvp = (JViewport) jsp.getComponent(0);
		((JTextArea) jvp.getComponent(0)).setText(value);
	}

	protected void doMousePressed() {
		XMLElementDialog xed = new XMLElementDialog(getDialog(), getOwner()
				.toLabel());
		xed.editXMLElement(new XMLRightOrgPanel(getOwner(), getOwner()
				.toLabel(), true, true, 0), true, false);
		if (!xed.isCanceled()) {
			setText(getOwner().toValue().toString());
			((XMLButtonAttribute) getOwner()).setModified(false);
		}
	}
}
