/*
 * Created on 2004-4-6
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.elements.formula.iot;

import com.ds.bpm.bpd.xml.elements.formula.Formula;
import com.ds.bpm.bpd.xml.elements.formula.FormulaParameter;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.formula.iot.XMLIOTServiceTreePanel;
import com.ds.bpm.formula.ExpressionParameter;

import javax.swing.*;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 权限公式参数－单个人员角设备选择
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-4-6 13:19:49
 * @version 1.0
 */
public class FormulaServiceEventParameter extends FormulaParameter {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 构造器
	 */
	public FormulaServiceEventParameter() {
		super();
	}

	/**
	 * 构造器
	 * 
	 * @param parent
	 * @param param
	 */
	public FormulaServiceEventParameter(Formula parent, ExpressionParameter param) {
		super(parent, param);
	}

	public XMLPanel getPanel() {
	    String title = param.getParameterDesc();
	  		if (title == null || title.trim().equals("")) {
	  			title = param.getParameterName();
	  		}
		return new XMLIOTServiceTreePanel(this, title, true, true,
				ListSelectionModel.SINGLE_SELECTION);
	}

	public String getParamValue() {
	    String val = param.getParameterCode() + "=";
		val = val + toValue().toString();
		return val;
	}
	
}
