/* TypeDeclarations.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexChoice;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.formula.FormalParameter;
import com.ds.bpm.bpd.xml.elements.formula.FormalParameters;

/**
 * Represents a WfMC DTD element that has the similar name. This class is a
 * collection of class <b>TypeDeclaration</b> instances.
 * 
 * @see XML
 */
public class TypeDeclarations extends XMLCollection {

	/**
	 * Creates a new instance of the class.
	 */
	public TypeDeclarations(Package p) {
		super(p);
	}

	// min=0, max=unbounded
	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		TypeDeclaration td = new TypeDeclaration(this, ((Package) myOwner));
		td.setRequired(true);
		return td;
	}

	/**
	 * Returns a type declaration with specified ID.
	 * 
	 * @param ID
	 *            The 'Id' attribute of wanted instance of TypeDeclaration
	 *            element defined within a package.
	 * @return Returns the instance of TypeDeclaration element that have the
	 *         specified ID as an 'Id' attribute if it exist among all defined
	 *         types within package, if it doesn't exist, <tt>null</tt> is
	 *         returned.
	 */
	public TypeDeclaration getDeclaredType(String ID) {
		return (TypeDeclaration) getCollectionElement(ID);
	}

	/**
	 * Checks if specified declared type can be removed. It can be removed only
	 * if it is not used anywhere.
	 */
	public boolean canRemoveElement(XMLElement el) {
		TypeDeclaration toRemove = (TypeDeclaration) el;

		// check if it is used within datafields

		// collect all data fields
		Set allDFS = new HashSet();
		allDFS.add(myOwner.get("DataFields"));
		WorkflowProcesses wps = (WorkflowProcesses) myOwner
				.get("WorkflowProcesses");
		Iterator it = wps.toCollection().iterator();
		while (it.hasNext()) {
			WorkflowProcess wp = (WorkflowProcess) it.next();
			allDFS.add(wp.get("DataFields"));
		}

		// Iterate through data fields and check if any data field uses
		// element that we want to remove
		it = allDFS.iterator();
		while (it.hasNext()) {
			DataFields dfs = (DataFields) it.next();
			Iterator itDFs = dfs.toCollection().iterator();
			while (itDFs.hasNext()) {
				DataField df = (DataField) itDFs.next();
				DataType dt = (DataType) df.get("DataType");
				Object choosen = ((DataTypes) dt.get("Type")).getChoosen();
				if (choosen instanceof DeclaredType) {
					if (((XMLComplexChoice) ((DeclaredType) choosen)
							.get("SubType")).getChoosen() == toRemove) {
						return false;
					}
				}
			}
		}

		// check if it is used within formal parameters of apps. or workflows

		// collect all FormalParameters
		Set allFPs = new HashSet();
		// application's FPs (from package)
		Applications aps = (Applications) myOwner.get("Applications");
		Iterator itApps = aps.toCollection().iterator();
		while (itApps.hasNext()) {
			Application app = (Application) itApps.next();
			XMLComplexChoice ch = (XMLComplexChoice) app.get("Choice");
			allFPs.add(ch.getChoices()[0]);
		}

		it = wps.toCollection().iterator();
		while (it.hasNext()) {
			WorkflowProcess wp = (WorkflowProcess) it.next();
			// workflow process FPs
			allFPs.add(wp.get("FormalParameters"));
			// application's FPs
			aps = (Applications) wp.get("Applications");
			itApps = aps.toCollection().iterator();
			while (itApps.hasNext()) {
				Application app = (Application) itApps.next();
				XMLComplexChoice ch = (XMLComplexChoice) app.get("Choice");
				allFPs.add(ch.getChoices()[0]);
			}
		}

		// Iterate through FPs and check if any FP uses
		// element that we want to remove
		it = allFPs.iterator();
		while (it.hasNext()) {
			FormalParameters fps = (FormalParameters) it.next();
			Iterator itFPs = fps.toCollection().iterator();
			while (itFPs.hasNext()) {
				FormalParameter fp = (FormalParameter) itFPs.next();
				DataType dt = (DataType) fp.get("DataType");
				Object choosen = ((DataTypes) dt.get("Type")).getChoosen();
				if (choosen instanceof DeclaredType) {
					if (((XMLComplexChoice) ((DeclaredType) choosen)
							.get("SubType")).getChoosen() == toRemove) {
						return false;
					}
				}
			}
		}

		return true;
	}

	public int[] getInvisibleTableFieldOrdinals() {
		int[] itfo = new int[2];
		itfo[0] = 3;
		itfo[1] = 4;
		return itfo;
	}

}
