/* Transitions.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：XML元素的路由集合类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTableControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLTablePanel;

/**
 * Represents a WfMC DTD element that has the similar name. This class is a
 * collection of class <b>Transition</b> instances.
 * 
 * @see XML
 */
public class Transitions extends XMLCollection {
	/**
	 * Creates a new instance of the class.
	 * 
	 * @param wpOrAs
	 *            The workflow process or activiy set that holds transitions,
	 *            and which member is this class instance.
	 */
	public Transitions(XMLComplexElement wpOrAs) {
		super(wpOrAs);
	}

	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		Transition t = new Transition(this);
		t.setRequired(true);
		return t;
	}

	/**
	 * Returns a set of transitions which source or target is the graph object
	 * with specified 'Id' attribute.
	 * 
	 * @param ID
	 *            ID of source or target graph object for transition, depending
	 *            of second attribute.
	 * @param st
	 *            These are possible values:
	 *            <p>
	 *            <ul>
	 *            <li> -1 - specified ID is source for transitions
	 *            <li> 0 - specified ID is source and target for transitions
	 *            <li> 1 - specified ID is target for transitions
	 *            </ul>
	 * @return The set of transitions for which the graph object with specified
	 *         ID is source or target, depending on second parameter of this
	 *         method.
	 */
	public Set getTransitions(String ID, int st) {
		Set trans = new HashSet();
		Transition t;
		Iterator it = refCollectionElements.iterator();
		while (it.hasNext()) {
			t = (Transition) it.next();
			if (st <= 0) {
				// if (t.get("From").toValue().toString().equals(ID)) {
				try {
					if (t.getFrom().get("Id").toString().equals(ID)) {
						trans.add(t);
					}
				} catch (Exception ex) {
				}
			}
			if (st >= 0) {
				// if (t.get("To").toValue().toString().equals(ID)) {
				try {
					if (t.getTo().get("Id").toString().equals(ID)) {
						trans.add(t);
					}
				} catch (Exception ex) {
				}
			}
		}
		return trans;
	}

	/**
	 * Returns the transition object with specified ID.
	 * 
	 * @param ID
	 *            ID of wanted transition
	 * @return The transitions that have specified ID if exists, <tt>null</tt>
	 *         otherwise.
	 */
	public Transition getTransition(String ID) {
		return (Transition) super.getCollectionElement(ID);
	}

	/**
	 * Returns <tt>true</tt> if specified data field or formal parameter is
	 * used in transition condition expression of any transition.
	 */
	public boolean canRemoveDataFieldOrFormalParameter(
			XMLCollectionElement toRemove) {
		return true;
	}

	public int[] getInvisibleTableFieldOrdinals() {
		int[] itfo = new int[4];
		itfo[0] = 2;
		itfo[1] = 3;
		itfo[2] = 5;
		itfo[3] = 6;
		return itfo;
	}

	/**
	 * Called by owner object after importing of XML file to do neccessary
	 * things on transitions after importing of XML.
	 */
	protected void afterImporting() {
		Iterator it = refCollectionElements.iterator();
		while (it.hasNext()) {
			Transition t = (Transition) it.next();
			t.afterImporting();
		}
	}

	// First, the controlled panel must be created, and then the control panel
	public XMLPanel getPanel() {
		isReadOnly = true;
		controlledPanel = new XMLTablePanel(this, "", false, false);
		controlPanel = new XMLTableControlPanel(this, "", true, false);
		return new XMLGroupPanel(this, new XMLPanel[] { controlledPanel,
				controlPanel }, toLabel(), XMLPanel.BOX_LAYOUT, false, true);
	}

	public Object toValue() {
		return String.valueOf(refCollectionElements.size());
	}

	// 实现clone方法
	public Object clone() {
		Transitions ts = (Transitions) super.clone();
		return ts;
	}
}
