/* TransitionRef.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;

/**
 * Represents a WfMC DTD element that has the similar name.
 */
public class TransitionRef extends XMLComplexElement {

	private XMLAttribute attrId = new XMLAttribute("Id"); // required

	/**
	 * Creates a new instance of the class.
	 */
	public TransitionRef() {
		super();

		fillStructure();
	}

	protected void fillStructure() {
		attrId.setRequired(true);
		complexStructure.add(attrId);
		attributes.add(attrId);
	}

	/**
	 * Overides super-class method to set the value to this element's 'Id'
	 * attribute.
	 * 
	 * @param v
	 *            The value to set.
	 */
	public void setValue(Object v) {
		attrId.setValue(v);
	}

	public Object toValue() {
		return attrId.toValue();
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		TransitionRef t = (TransitionRef) super.clone();
		t.attrId = (XMLAttribute) this.attrId.clone();
		t.fillStructure();

		return t;
	}

	public String toString() {
		return attrId.toString();
	}

}
