/* TimeEstimation.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLComplexElement;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class TimeEstimation extends XMLComplexElement {
	private WaitingTime refWaitingTime = new WaitingTime(); // min=0

	private WorkingTime refWorkingTime = new WorkingTime(); // min=0

	private Duration refDuration = new Duration(); // min=0

	/**
	 * Creates a new instance of the class.
	 */
	public TimeEstimation() {
		super();

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		complexStructure.add(refWaitingTime);
		complexStructure.add(refWorkingTime);
		complexStructure.add(refDuration);
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		TimeEstimation t = (TimeEstimation) super.clone();

		t.refWaitingTime = (WaitingTime) this.refWaitingTime.clone();
		t.refWorkingTime = (WorkingTime) this.refWorkingTime.clone();
		t.refDuration = (Duration) this.refDuration.clone();

		t.fillStructure();

		return t;
	}

}
