/* RedefinableHeader.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.enums.process.ProcessDefEnums;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTextPanel;
import com.ds.enums.EnumsUtil;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class RedefinableHeader extends XMLComplexElement {
    private transient XMLElement myOwner = null;

    // 版本创建人ID
    private Author refAuthor = new Author(); // min=0

    // 当前版本号
    private Version refVersion = new Version(); // min=0

    // 流程监控人组
    private Responsibles refResponsibles; // min=0

    /** Enables canceling of changes to the responsible collection. */
    private Responsibles clonedResps;

    private boolean fromXMLExecuted = false;

    private XMLAttribute attrPublicationStatus = new XMLAttribute(EnumsUtil.getAttribute(ProcessDefEnums.PublicationStatus));

    /**
     * Creates a new instance of the class.
     */
    public RedefinableHeader(XMLComplexElement packageOrWProcess) {
	super();

	refResponsibles = new Responsibles(packageOrWProcess);
	fillStructure();
    }

    /**
     * Defines the super-class method. Read the explanation for this method within XMLComplexElement class.
     */
    protected void fillStructure() {
	complexStructure.add(attrPublicationStatus);
	attributes.add(attrPublicationStatus);
	complexStructure.add(refAuthor);
	complexStructure.add(refVersion);
	complexStructure.add(refResponsibles);
    }

    /**
     * Overrides super-class method to realize this class specific writting to XML file.
     */
    public void toXML(Node parent) throws DOMException {
	super.toXML(parent);
    }

    public void fromXML(Node node) {
	fromXMLExecuted = true;
	attrPublicationStatus.setValue("");
	super.fromXML(node);
    }

    protected void afterImporting() {
	// adjusting responsibles of package
	refResponsibles.afterImporting();
	if (!fromXMLExecuted) {
	    attrPublicationStatus.setValue("");
	}
    }

    /**
     * Uses a trick to set the cloned instance of responsibles to be edited, so that canceling of changes to the
     * responsible collection can be handled - the real instance of responsibles is set to the cloned instance within
     * the isValidData method.
     */
    public XMLPanel getPanel() {
	complexStructure.remove(refResponsibles);
	clonedResps = (Responsibles) refResponsibles.clone();
	complexStructure.add(5, clonedResps);
	XMLPanel p = super.getPanel();
	complexStructure.remove(clonedResps);
	complexStructure.add(5, refResponsibles);
	return p;
    }

    /**
     * This method is called only if user doesn't press Cancel button within the dialog for editing RedefinableHeader
     * properties, so the changes to the real collection of Responsibles are applied here.
     * 
     * @param groupPanel
     *            The panel for editing parameters.
     * @return always returns <tt>true</tt>.
     */
    public boolean isValidEnter(XMLPanel groupPanel) {
	// replace responsibles with the one entered
	if (clonedResps != null) {
	    complexStructure.remove(refResponsibles);
	    refResponsibles = clonedResps;
	    complexStructure.add(5, refResponsibles);
	}
	// 验证版本输入字符串是否为int
	XMLTextPanel p = (XMLTextPanel) ((XMLGroupPanel) groupPanel).getPanel(3);
	String value = p.getText();
	if (!Utils.isInt(value)) {
	    XMLPanel.errorMessage(groupPanel.getDialog(), ResourceManager.getLanguageDependentString("Sys.ErrorMessage.dialogTitle"), p.getOwner().toLabel() + ResourceManager.getLanguageDependentString("Sys.Colon"),
		    ResourceManager.getLanguageDependentString("Sys.ErrorMessage.invalid"));
	    p.requestFocus();
	    return false;
	} else {
	    return true;
	}
    }

    // 实现clone方法
    public Object clone() {
	RedefinableHeader rh = (RedefinableHeader) super.clone();
	rh.attrPublicationStatus = (XMLAttribute) this.attrPublicationStatus.clone();
	rh.attrPublicationStatus.setValue("UNDER_TEST");
	rh.attrPublicationStatus.refreshDisplayValue();
	rh.refAuthor = (Author) this.refAuthor.clone();
	rh.refAuthor.setValue("");
	rh.refVersion = (Version) this.refVersion.clone();
	rh.refResponsibles = (Responsibles) this.refResponsibles.clone();
	rh.fillStructure();
	return rh;
    }

}
