/* ParticipantType.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class ParticipantType extends XMLComplexElement {
	// required
	private XMLAttribute attrType = new XMLAttribute("Type", new String[] {
			"RESOURCE_SET", "RESOURCE", "ROLE", "ORGANIZATIONAL_UNIT", "HUMAN",
			"SYSTEM" }, 2, false, true);

	/**
	 * Creates a new instance of the class.
	 */
	public ParticipantType() {
		super();

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		attrType.setRequired(true);
		complexStructure.add(attrType);
		attributes.add(attrType);
	}

	/**
	 * Prepares the panel with a radio buttons to choose the one of allowed
	 * participant types.
	 * 
	 * @return XMLPanel to be shown.
	 */
	public XMLPanel getPanel() {
		return attrType.getPanel();
	}

	/**
	 * Returns the value of choosen type. The value is not the text displayed in
	 * combo box (this is a language dependent representation of value), but the
	 * text defined in WfMC DTD for this element "Type" attribute.
	 * 
	 * @return The value of choosen type.
	 */
	public Object toValue() {
		return attrType.toValue();
	}

	/**
	 * Overrides super-class method to retreive the choosen type of participant.
	 * This is used when displaying instance of this class within
	 * 
	 * @see XMLTreePanel.
	 * @return The type of participant.
	 */
	public String toString() {
		return attrType.toString();
	}

	// 实现clone方法
	public Object clone() {
		ParticipantType pt = (ParticipantType) super.clone();
		pt.attrType = (XMLAttribute) this.attrType.clone();
		pt.fillStructure();
		return pt;
	}
}
