/*
 * Created on 2005-12-26
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2005 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.JOptionPane;

import com.ds.bpm.enums.listener.ListenerAttEnums;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.panels.XMLComboPanel;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLMultiLineTextPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.enums.event.ExpressionTypeEnums;
import com.ds.enums.EnumsUtil;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 工作流监听器元素类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2008
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author wenzhangli
 * @version 2.0
 */
public class Listener extends XMLCollectionElement {

    public static final String PROCESS_TYPE = "Process";

    public static final String ACTIVITY_TYPE = "Activity";

    // 监听器名称
    private XMLAttribute listenerName = new XMLAttribute("Name");

    private XMLAttribute expressionEventType = new XMLAttribute(EnumsUtil.getAttribute(ListenerAttEnums.ExpressionEventType));;

    private XMLAttribute expressionListenerType = new XMLAttribute(EnumsUtil.getAttribute(ListenerAttEnums.ExpressionListenerType));;

    private XMLAttribute listenerEvent = new XMLAttribute(EnumsUtil.getAttribute(ListenerAttEnums.ListenerEvent));;

    private XMLAttribute expressionStr = new XMLAttribute("expressionStr") {
	public XMLPanel getPanel() {
	    this.p = new XMLMultiLineTextPanel(this, false);

	    return p;
	}
    };; // min=0

    // 实现类
    private XMLAttribute realizeClass = new XMLAttribute("RealizeClass");

    // 可配置的监听器名称
    private String[] names;

    // 该监听器是否存在
    private boolean isExisted = true;

    /**
     * 构造器
     * 
     * @param myCollection
     */
    public Listener(XMLCollection myCollection) {
	super(myCollection);
	setLabelName(ResourceManager.getLanguageDependentString("Process.Listener.display"));

	// 初始化页面显示信息
	// 监听器ID
	attrId.setReadOnly(true);

	attrId.setLabelName(ResourceManager.getLanguageDependentString("Process.Listener.ID.display"));
	init();
	fillStructure();

    }

    protected void fillStructure() {
	super.fillStructure();

	expressionListenerType = new XMLAttribute(EnumsUtil.getAttribute(ListenerAttEnums.ExpressionListenerType)) {

	    public void itemChanged(Object o) {
		XMLSelectOption selectOption = (XMLSelectOption) o;
		String textname = selectOption.getText();
		Listener.this.typeChange(textname);

	    }
	};
	expressionEventType.setRequired(true);

	attributes.add(listenerName);

	attributes.add(listenerEvent);

	attributes.add(realizeClass);

	attributes.add(expressionStr);

	attributes.add(expressionEventType);

	attributes.add(expressionListenerType);

	complexStructure.add(listenerName);

	complexStructure.add(realizeClass);

	complexStructure.add(listenerEvent);

	complexStructure.add(expressionEventType);

	complexStructure.add(expressionListenerType);

	complexStructure.add(expressionStr);

    }

    public void typeChange(String textname) {

	if (ExpressionTypeEnums.Expression.getType().equals(textname)) {
	    if (myCollection.getOwner() instanceof WorkflowProcess) {
		realizeClass.setValue("com.ds.bpm.engine.event.DefaultProcessListenerExpressionPar");
	    } else if (myCollection.getOwner() instanceof Activity) {
		realizeClass.setValue("com.ds.bpm.engine.event.DefaultActivityListenerExpressionPar");
	    }

	    listenerName.setValue(ResourceManager.getLanguageDependentString("Process.Listener.defaultExpressionPar.display"));

	    listenerName.setReadOnly(true);
	    listenerName.getOldPanel().updatePanel(new XMLComboPanel(listenerName, XMLPanel.BOX_LAYOUT, false));

	    expressionStr.setReadOnly(false);
	    expressionStr.setRequired(true);
	    expressionStr.getOldPanel().updatePanel(new XMLMultiLineTextPanel(this, false));
	} else if (ExpressionTypeEnums.Listener.getType().equals(textname)) {
	    listenerName.setReadOnly(false);
	    listenerName.getOldPanel().updatePanel(new XMLComboPanel(listenerName, XMLPanel.BOX_LAYOUT, false));

	    expressionStr.setReadOnly(true);
	    expressionStr.setRequired(false);
	    expressionStr.getOldPanel().updatePanel(new XMLMultiLineTextPanel(this, false));

	} else if (ExpressionTypeEnums.Script.getType().equals(textname)) {
	    if (myCollection.getOwner() instanceof WorkflowProcess) {
		realizeClass.setValue("com.ds.bpm.engine.event.DefaultClientProcessListenerExpressionPar");
	    } else if (myCollection.getOwner() instanceof Activity) {
		realizeClass.setValue("com.ds.bpm.engine.event.DefaultClientActivityListenerExpressionPar");
	    }
	    realizeClass.refreshPanelValue();

	    listenerName.setValue(ResourceManager.getLanguageDependentString("Process.Listener.defaultClientExpressionPar.display"));

	    listenerName.setReadOnly(true);
	    listenerName.getOldPanel().updatePanel(new XMLComboPanel(listenerName, XMLPanel.BOX_LAYOUT, false));
	    expressionStr.setReadOnly(false);
	    expressionStr.setRequired(true);
	    expressionStr.getOldPanel().updatePanel(new XMLMultiLineTextPanel(this, false));

	}
	// Listener.this.getPanel().setOwner(Listener.this);

    }

    private void init() {
	List processListeners = ((Listeners) myCollection).getProcessListeners();

	String[] pelem = new String[3];
	pelem[0] = "流程监听器";
	pelem[1] = Listener.PROCESS_TYPE;
	pelem[2] = "com.ds.bpm.engine.event.DefaultClientProcessListenerExpressionPar";

	processListeners.add(pelem);

	List actListeners = ((Listeners) myCollection).getActivityListeners();

	if (actListeners.isEmpty()) {
	    String[] aelem = new String[3];
	    aelem[0] = "活动默认监听";
	    aelem[1] = Listener.ACTIVITY_TYPE;
	    aelem[2] = "com.ds.bpm.engine.event.DefaultClientActivityListenerExpressionPar";
	    actListeners.add(aelem);
	}

	final String[] types;
	final String[] classes;
	List temp;
	if (myCollection.getOwner() instanceof WorkflowProcess) {
	    names = new String[processListeners.size()];
	    types = new String[processListeners.size()];
	    classes = new String[processListeners.size()];
	    temp = new ArrayList(processListeners);
	} else {
	    names = new String[actListeners.size()];
	    types = new String[actListeners.size()];
	    classes = new String[actListeners.size()];
	    temp = new ArrayList(actListeners);
	}
	for (int i = 0; i < temp.size(); i++) {
	    String[] elem = (String[]) temp.get(i);
	    names[i] = elem[0];
	    types[i] = elem[1];
	    classes[i] = elem[2];
	}
	// 监听器名称
	if (names.length > 0) {
	    
	    listenerName = new XMLAttribute("Name", names, 0) {

		public void itemChanged(Object o) {
		    String name = (String) o;
		    for (int i = 0; i < names.length; i++) {
			if (names[i].equals(name)) {
			    listenerEvent.setValue(types[i]);
			    listenerEvent.refreshDisplayValue();
			    listenerEvent.refreshPanelValue();
			    realizeClass.setValue(classes[i]);
			    realizeClass.refreshPanelValue();
			}
		    }
		}
	    };
	}

	listenerName.setRequired(true);
	
	listenerName.setLabelName(ResourceManager.getLanguageDependentString("Process.Listener.Name.display"));

	expressionStr.setLabelName(ResourceManager.getLanguageDependentString("Process.Listener.ListenerEvent.expressionStr"));

	// 订阅事件
	listenerEvent.setVisible(false);
	listenerEvent.setLabelName(ResourceManager.getLanguageDependentString("Process.Listener.ListenerEvent.display"));
	if (types.length > 0) {
	    listenerEvent.setValue(types[0]);
	}
	listenerEvent.refreshDisplayValue();
	// listenerEvent.setReadOnly(true);
	// 实现类
	realizeClass.setRequired(true);
	realizeClass.setReadOnly(true);
	realizeClass.setLabelName(ResourceManager.getLanguageDependentString("Process.Listener.RealizeClass.display"));
	if (classes.length > 0) {
	    realizeClass.setValue(classes[0]);
	}
    }

    public String toString() {
	return listenerName.toString();
    }

    /**
     * 得到Listener的显示Panel
     */
    public XMLPanel getPanel() {
	if (!isExisted) {
	    JOptionPane.showMessageDialog((new XMLPanel()).getDialog(), ResourceManager.getLanguageDependentString("Listener.NotExisted.error"), ResourceManager.getLanguageDependentString("Sys.ErrorMessage.dialogTitle"),
		    JOptionPane.WARNING_MESSAGE);
	    return null;
	}
	// if (names == null || names.length == 0) {
	// JOptionPane.showMessageDialog((new XMLPanel()).getDialog(),
	// ResourceManager.getLanguageDependentString("Listener.Initialize.error"),
	// ResourceManager.getLanguageDependentString("Sys.ErrorMessage.dialogTitle"),
	// JOptionPane.WARNING_MESSAGE);
	// return null;
	// }

	XMLPanel classListener = new XMLGroupPanel(this, new XMLElement[] { attrId, listenerName, expressionListenerType,expressionEventType,  listenerEvent, realizeClass, expressionStr },
		ResourceManager.getLanguageDependentString("Process.Listener.display"));

	// XMLPanel expressionListener=new XMLGroupPanel(this, new XMLElement[]
	// { attrId, expressionName,expressionEventType,expression},
	// ResourceManager
	// .getLanguageDependentString("Process.Listener.expression.Name.display"));
	//
	// return new XMLTabbedPanel(this, new XMLPanel[] {
	// expressionListener,classListener});
	return classListener;

    }

    public void toXML(Node parent) {
	if (isEmpty() && !isRequired())
	    return;
	if (parent != null) {
	    String nsURI = ResourceManager.getLanguageDependentString("Sys.XML.nsURI");
	    Node node = (parent.getOwnerDocument()).createElementNS(nsURI, name);
	    node.setPrefix(nsURI);

	    // for (Iterator it = complexStructure.iterator(); it.hasNext();) {
	    //
	    // XMLElement el = (XMLElement) it.next();
	    // System.out.println(el.toLabel() + el.toValue());
	    // el.toXML(node);
	    // }

	    for (Iterator it = attributes.iterator(); it.hasNext();) {
		XMLElement el = (XMLElement) it.next();
		el.toXML(node);
	    }
	    // /expressionEventType.toXML(parent);
	    parent.appendChild(node);
	}
    }

    // 实现clone方法
    public Object clone() {
	Listener l = (Listener) super.clone();
	l.attrId.setValue(myCollection.generateID());
	l.listenerName = (XMLAttribute) this.listenerName.clone();
	l.listenerEvent = (XMLAttribute) this.listenerEvent.clone();
	l.realizeClass = (XMLAttribute) this.realizeClass.clone();
	l.expressionStr = (XMLAttribute) this.expressionStr.clone();
	l.expressionListenerType = (XMLAttribute) this.expressionListenerType.clone();
	l.expressionEventType = (XMLAttribute) this.expressionEventType.clone();
	l.fillStructure();
	return l;
    }

    public void afterImporting() {
	String lName = listenerName.toValue().toString();
	String lEvent = listenerEvent.toValue().toString();
	String clasz = realizeClass.toValue().toString();

	String lisenterType = expressionEventType.toValue().toString();
	String expressionstr = expressionStr.toValue().toString();

	init();
	complexStructure.set(1, listenerName);
	listenerName.setValue(lName);
	listenerName.refreshDisplayValue();
	listenerEvent.setValue(lEvent);
	listenerEvent.refreshDisplayValue();
	realizeClass.setValue(clasz);

	expressionEventType.setValue(lisenterType);
	expressionEventType.refreshDisplayValue();
	expressionEventType.refreshPanelValue();
	expressionStr.setValue(expressionstr);
	expressionStr.refreshPanelValue();
	expressionStr.refreshDisplayValue();
	realizeClass.refreshDisplayValue();
	isExisted = Utils.isExistedInArray(names, lName);
    }
}
