/* ExternalPackage.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.xml.Path;
import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLLocationPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class ExternalPackage extends XMLComplexElement {
	private ExtendedAttributes refExtendedAttributes = new ExtendedAttributes(
			this); // min=0

	private XMLAttribute attrHref;

	/** Enables canceling of changes to the extended attributes collection. */
	private ExtendedAttributes clonedEAs;

	private ExternalPackages myOwner = null;

	/**
	 * Creates a new instance of the class.
	 */
	public ExternalPackage(ExternalPackages eps) {
		super();

		myOwner = eps;
		attrHref = new AttrHref("href");

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		super.fillStructure();

		attrHref.setRequired(true);
		complexStructure.add(attrHref);
		attributes.add(attrHref);
		complexStructure.add(refExtendedAttributes);
	}

	public XMLPanel getPanel() {
		if (attrHref != null && attrHref.toString().trim().length() > 0) {
			attrHref.setReadOnly(true);
		}
		clonedEAs = (ExtendedAttributes) refExtendedAttributes.clone();
		return new XMLGroupPanel(this,
				new XMLElement[] { attrHref, clonedEAs }, toLabel());
	}

	/**
	 * Overrides <code>toString</code> method to return the path to some
	 * external file. This string is used to visually display the path name into
	 * dialog.
	 * 
	 * @return The string that represents a path to some file.
	 */
	public String toString() {
		return attrHref.toString();
	}

	public Package getMyPackage() {
		return (Package) ((ExternalPackages) myOwner).getOwner();
	}

	/**
	 * This method is called only if user doesn't press Cancel button within the
	 * dialog for editing ExternalPackage properties, so the changes to the real
	 * collection of ExternalPackage are applied here.
	 * 
	 * @param groupPanel
	 *            The panel for editing parameters.
	 * @return always returns <tt>true</tt>.
	 */
	public boolean isValidEnter(XMLPanel groupPanel) {
		if (clonedEAs != null) {
			complexStructure.remove(refExtendedAttributes);
			refExtendedAttributes = clonedEAs;
			complexStructure.add(1, refExtendedAttributes);
		}
		return true;
	}

	public class AttrHref extends XMLAttribute {
		AttrHref(String name) {
			super(name);
		}

		public void setValue(Object v) {
			try {
				Path path = new Path(v.toString());
				String repBS = Path.getRelativePath(path, new Path(BPD.getInstance().getXMLInterface()
						.getParentDirectory((Package) myOwner.getOwner())));
				value = XMLUtil.replaceBackslashesWithSlashes(repBS);
			} catch (Exception ex2) {
				value = v;
			}
		}

		public void setPathDirectly(String path) {
			value = XMLUtil.replaceBackslashesWithSlashes(path);
		}

		public XMLPanel getPanel() {
			return new XMLLocationPanel(this, XMLPanel.BOX_LAYOUT, 0);
		}
	}

}
