/* Deadline.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;

import org.w3c.dom.Node;

/**
 * Represents a WfMC DTD element that has the similar name.
 */
public class Deadline extends XMLComplexElement {
	// private Set refXpression=new HashSet(); // min=0, max=unbounded
	private DeadlineCondition refDeadlineCondition = new DeadlineCondition(); // min=1,
																				// max=1

	private ExceptionName refExceptionName = new ExceptionName(); // min=1,
																	// max=1

	private XMLAttribute attrExecution = new XMLAttribute("Execution",
			new String[] { "", "ASYNCHR", "SYNCHR" }, 1);

	/**
	 * Creates a new instance of the class.
	 */
	public Deadline() {
		super();

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		complexStructure.add(attrExecution);
		attributes.add(attrExecution);
		refDeadlineCondition.setRequired(true);
		complexStructure.add(refDeadlineCondition);
		refExceptionName.setRequired(true);
		complexStructure.add(refExceptionName);
	}

	public void fromXML(Node node) {
		attrExecution.setValue("");
		super.fromXML(node);
	}

	/**
	 * Overrides super-class method to retrieve the defined condition.
	 * 
	 * @return The condition of transition.
	 */
	public String toString() {
		return refDeadlineCondition.toString();
	}

	public Object toValue() {
		return refDeadlineCondition.toValue();
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		Deadline c = (Deadline) super.clone();

		c.attrExecution = (XMLAttribute) this.attrExecution.clone();
		c.refDeadlineCondition = (DeadlineCondition) this.refDeadlineCondition
				.clone();
		c.refExceptionName = (ExceptionName) this.refExceptionName.clone();
		c.fillStructure();

		return c;
	}

}
