/*
 * Created on 2005-12-26
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2005 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.JOptionPane;

import com.ds.bpm.enums.listener.ListenerAttEnums;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.panels.XMLComboPanel;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLMultiLineTextPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.enums.EnumsUtil;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 工作流监听器元素类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2008
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author wenzhangli
 * @version 2.0
 */
public class CommandListener extends XMLCollectionElement {

    public static final String COMMAND_TYPE = "Command";

    // 监听器名称
    private XMLAttribute listenerName = new XMLAttribute("Name");

    // 订阅事件

    private XMLAttribute expressionEventType = new XMLAttribute(EnumsUtil.getAttribute(ListenerAttEnums.CommandEvent));

    private XMLAttribute expressionStr = new XMLAttribute("expressionStr") {
	public XMLPanel getPanel() {
	    this.p = new XMLMultiLineTextPanel(this, false);

	    return p;
	}
    };; // min=0

    // 实现类
    private XMLAttribute realizeClass = new XMLAttribute("RealizeClass");

    // 可配置的监听器名称
    private String[] names;

    // 该监听器是否存在
    private boolean isExisted = true;

    /**
     * 构造器
     * 
     * @param myCollection
     */
    public CommandListener(XMLCollection myCollection) {
	super(myCollection);
	setLabelName(ResourceManager.getLanguageDependentString("Process.command.Listener.display"));

	// 初始化页面显示信息
	// 监听器ID
	attrId.setReadOnly(true);

	attrId.setLabelName(ResourceManager.getLanguageDependentString("Process.command.Listener.ID.display"));
	init();
	fillStructure();

    }

    protected void fillStructure() {
	super.fillStructure();

	complexStructure.add(listenerName);
	attributes.add(listenerName);

	complexStructure.add(realizeClass);
	attributes.add(realizeClass);
	attributes.add(expressionStr);

	attributes.add(expressionEventType);
	complexStructure.add(expressionStr);

	complexStructure.add(expressionEventType);

    }

    public void typeChange(String textname) {

	if ("listener".equals(textname)) {
	    listenerName.setReadOnly(false);
	    listenerName.getOldPanel().updatePanel(new XMLComboPanel(listenerName, XMLPanel.BOX_LAYOUT, false));
	    expressionEventType.setReadOnly(true);
	    expressionEventType.setRequired(false);
	    expressionEventType.getOldPanel().updatePanel(new XMLComboPanel(expressionEventType, XMLPanel.BOX_LAYOUT, false));
	    expressionStr.setReadOnly(true);
	    expressionStr.setRequired(false);
	    expressionStr.getOldPanel().updatePanel(new XMLMultiLineTextPanel(this, false));

	} else if ("clientexpression".equals(textname)) {
	    if (myCollection.getOwner() instanceof WorkflowProcess) {
		realizeClass.setValue("com.ds.bpm.engine.event.DefaultClientProcessListenerExpressionPar");
	    } else if (myCollection.getOwner() instanceof Activity) {
		realizeClass.setValue("com.ds.bpm.engine.event.DefaultClientActivityListenerExpressionPar");
	    }
	    realizeClass.refreshPanelValue();

	    listenerName.setValue(ResourceManager.getLanguageDependentString("Process.Listener.defaultClientExpressionPar.display"));

	    listenerName.setReadOnly(true);
	    listenerName.getOldPanel().updatePanel(new XMLComboPanel(listenerName, XMLPanel.BOX_LAYOUT, false));
	    expressionEventType.setReadOnly(false);
	    expressionEventType.setRequired(true);
	    expressionEventType.refreshDisplayValue();
	    expressionEventType.getOldPanel().updatePanel(new XMLComboPanel(expressionEventType, XMLPanel.BOX_LAYOUT, false));
	    expressionStr.setReadOnly(false);
	    expressionStr.setRequired(true);
	    expressionStr.getOldPanel().updatePanel(new XMLMultiLineTextPanel(this, false));

	}
	// Listener.this.getPanel().setOwner(Listener.this);

    }

    private void init() {

	List actListeners = ((CommandListeners) myCollection).getActivityListeners();
	final String[] types;
	final String[] classes;
	List temp;

	if (actListeners.isEmpty()) {
	    String[] aelem = new String[3];
	    aelem[0] = "命令默认监听";
	    aelem[1] = Listener.ACTIVITY_TYPE;
	    aelem[2] = "com.ds.bpm.engine.event.DefaultClientActivityListenerExpressionPar";
	    actListeners.add(aelem);
	}

	names = new String[actListeners.size()];
	types = new String[actListeners.size()];
	classes = new String[actListeners.size()];
	temp = new ArrayList(actListeners);

	for (int i = 0; i < temp.size(); i++) {
	    String[] elem = (String[]) temp.get(i);
	    names[i] = elem[0];
	    types[i] = elem[1];
	    classes[i] = elem[2];
	}
	listenerName.setValue("命令默认监听");
	listenerName.setRequired(true);
	listenerName.setLabelName(ResourceManager.getLanguageDependentString("Process.command.Listener.Name.display"));

	expressionStr.setLabelName(ResourceManager.getLanguageDependentString("Process.command.Listener.ListenerEvent.expressionStr"));

	// 实现类
	realizeClass.setRequired(true);
	realizeClass.setReadOnly(true);
	realizeClass.setLabelName(ResourceManager.getLanguageDependentString("Process.command.Listener.RealizeClass.display"));
	if (classes.length > 0) {
	    realizeClass.setValue(classes[0]);
	}
    }

    public String toString() {
	return listenerName.toString();
    }

    /**
     * 得到Listener的显示Panel
     */
    public XMLPanel getPanel() {
	if (!isExisted) {
	    JOptionPane.showMessageDialog((new XMLPanel()).getDialog(), ResourceManager.getLanguageDependentString("Listener.NotExisted.error"), ResourceManager.getLanguageDependentString("Sys.ErrorMessage.dialogTitle"),
		    JOptionPane.WARNING_MESSAGE);
	    return null;
	}
	// if (names == null || names.length == 0) {
	// JOptionPane.showMessageDialog((new XMLPanel()).getDialog(),
	// ResourceManager.getLanguageDependentString("Listener.Initialize.error"),
	// ResourceManager.getLanguageDependentString("Sys.ErrorMessage.dialogTitle"),
	// JOptionPane.WARNING_MESSAGE);
	// return null;
	// }

	XMLPanel classListener = new XMLGroupPanel(this, new XMLElement[] { attrId, listenerName, realizeClass, expressionEventType, expressionStr }, ResourceManager.getLanguageDependentString("Process.command.Listener.display"));

	// XMLPanel expressionListener=new XMLGroupPanel(this, new XMLElement[]
	// { attrId, expressionName,expressionEventType,expression},
	// ResourceManager
	// .getLanguageDependentString("Process.Listener.expression.Name.display"));
	//
	// return new XMLTabbedPanel(this, new XMLPanel[] {
	// expressionListener,classListener});
	return classListener;

    }

    public void toXML(Node parent) {
	if (isEmpty() && !isRequired())
	    return;
	if (parent != null) {
	    String nsURI = ResourceManager.getLanguageDependentString("Sys.XML.nsURI");
	    Node node = (parent.getOwnerDocument()).createElementNS(nsURI, name);
	    node.setPrefix(nsURI);

	    for (Iterator it = complexStructure.iterator(); it.hasNext();) {
		XMLElement el = (XMLElement) it.next();
		el.toXML(node);
	    }

	    for (Iterator it = attributes.iterator(); it.hasNext();) {
		XMLElement el = (XMLElement) it.next();
		el.toXML(node);
	    }
	    parent.appendChild(node);
	}
    }

    // 实现clone方法
    public Object clone() {
	CommandListener l = (CommandListener) super.clone();
	l.attrId.setValue(myCollection.generateID());
	l.listenerName = (XMLAttribute) this.listenerName.clone();

	l.realizeClass = (XMLAttribute) this.realizeClass.clone();
	l.expressionStr = (XMLAttribute) this.expressionStr.clone();
	l.expressionEventType = (XMLAttribute) expressionEventType.clone();
	;
	l.fillStructure();
	return l;
    }

    public void afterImporting() {
	String lName = listenerName.toValue().toString();

	String clasz = realizeClass.toValue().toString();
	String eventType = expressionEventType.toValue().toString();

	String expressionstr = expressionStr.toValue().toString();

	init();
	complexStructure.set(1, listenerName);
	listenerName.setValue(lName);
	listenerName.refreshDisplayValue();

	realizeClass.setValue(clasz);

	expressionEventType.setValue(eventType);
	expressionEventType.refreshDisplayValue();
	expressionEventType.refreshPanelValue();

	expressionStr.setValue(expressionstr);
	expressionStr.refreshPanelValue();
	expressionStr.refreshDisplayValue();
	realizeClass.refreshDisplayValue();
	isExisted = Utils.isExistedInArray(names, lName);
    }
}
