/* BasicType.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class BasicType extends XMLComplexElement {
	// must be one of following: STRING, FLOAT, INTEGER, REFERENCE, DATETIME,
	// BOOLEAN OR PERFORMER
	// required
	private XMLAttribute attrType = new XMLAttribute("Type", new String[] {
			"STRING", "FLOAT", "INTEGER", "REFERENCE", "DATETIME", "BOOLEAN",
			"PERFORMER" }, 0);

	/**
	 * Creates a new instance of the class.
	 */
	public BasicType() {
		super();
		attrType.setLabelName(XMLUtil.getLanguageDependentString("SubTypeKey"));

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		attrType.setRequired(true);
		complexStructure.add(attrType);
		attributes.add(attrType);
	}

	/**
	 * Returns the value of choosen type. The value is not the text displayed in
	 * combo box (this is a language dependent representation of value), but the
	 * text defined in WfMC DTD for this element "Type" attribute.
	 * 
	 * @return The value of choosen type.
	 */
	public Object toValue() {
		return attrType.toValue();
	}

	/**
	 * Prepares the panel with a combo box to choose the one of allowed basic
	 * types.
	 * 
	 * @return XMLPanel to be shown.
	 */
	public XMLPanel getPanel() {
		return attrType.getPanel();
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		BasicType bt = (BasicType) super.clone();

		bt.attrType = (XMLAttribute) this.attrType.clone();
		bt.fillStructure();

		return bt;
	}

	public void refreshLabelName() {
		super.refreshLabelName();
		attrType.setLabelName(XMLUtil.getLanguageDependentString("SubTypeKey"));
	}

}
