/* ArrayType.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLUtil;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class ArrayType extends XMLComplexElement {
	// must be defined
	private DataTypes refType;

	private XMLAttribute attrLowerIndex = new XMLAttribute("LowerIndex"); // required

	private XMLAttribute attrUpperIndex = new XMLAttribute("UpperIndex"); // required

	private transient DataTypes myOwner;

	/**
	 * Creates a new instance of the class.
	 */
	public ArrayType(DataTypes dtc, Package p) {
		super();
		myOwner = dtc;
		refType = new DataTypes(this, p, null, 0);
		refType.setLabelName(XMLUtil.getLanguageDependentString("SubTypeKey"));
		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		isRequired = true;
		attrLowerIndex.setRequired(true);
		attrUpperIndex.setRequired(true);

		complexStructure.add(attrLowerIndex);
		attributes.add(attrLowerIndex);
		complexStructure.add(attrUpperIndex);
		attributes.add(attrUpperIndex);
		refType.setRequired(true);
		complexStructure.add(refType);
	}

	public DataTypes getOwner() {
		return myOwner;
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	/*
	 * public Object clone () { ArrayType at=(ArrayType)super.clone();
	 * at.refType=(XMLComplexChoice)this.refType.clone();
	 * at.attrLowerIndex=(XMLAttribute)this.attrLowerIndex.clone();
	 * at.attrUpperIndex=(XMLAttribute)this.attrUpperIndex.clone();
	 * at.fillStructure(); return at; }
	 */

	public void refreshLabelName() {
		super.refreshLabelName();
		refType.setLabelName(XMLUtil.getLanguageDependentString("SubTypeKey"));
	}

}
