/* Tool.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：XML元素的自动活动类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.activity;

import java.util.Iterator;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLComplexChoice;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.ActualParameter;
import com.ds.bpm.bpd.xml.elements.ActualParameters;
import com.ds.bpm.bpd.xml.elements.Application;
import com.ds.bpm.bpd.xml.elements.Applications;
import com.ds.bpm.bpd.xml.elements.Description;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Represents a WfMC DTD element that has the similar name. 自动活动类
 */
public class Service extends XMLCollectionElement {
	/**
	 * Defined application at the workflow process level where instance of
	 * object where this instance of element belongs. Applications defined at
	 * the Package level are also included.
	 */
	private transient Applications definedApplications = null;

	private ActualParameters refActualParameters; // min=0

	private Description refDescription = new Description(); // min=0

	private ExtendedAttributes refExtendedAttributes = new ExtendedAttributes(
			this);

	// min=0

	/** Holds reference to choosen application for Tool instance. */
	private XMLComplexChoice helperElement;

	/** Enables canceling of changes to the actual param. collection. */
	private ActualParameters clonedAPs;

	/** Enables canceling of changes to the extended attributes collection. */
	private ExtendedAttributes clonedEAs;

	private XMLAttribute attrType = new XMLAttribute("Type", new String[] { "",
			"APPLICATION", "PROCEDURE" }, 1);

	// 自动活动执行体名称
	private XMLAttribute name = new XMLAttribute("Name");

	// 自动活动执行体实现类
	private XMLAttribute execClass = new XMLAttribute("ExecClass");

	/**
	 * Creates a new instance of the class.
	 * 
	 * @param services
	 *            The reference to collection of tools where this instance will
	 *            be put into.
	 * @param wp
	 *            The workflow process that holds activity which member is this
	 *            class instance.
	 */
	public Service(Services services, WorkflowProcess wp) {
		super(services);
		// 初始化页面显示属性
		setLabelName(ResourceManager
				.getLanguageDependentString("Activity.General.Type.Service.value"));
		name.setLabelName(ResourceManager
				.getLanguageDependentString("Activity.Service.name"));
		execClass.setLabelName(ResourceManager
				.getLanguageDependentString("Activity.Service.execClass"));
		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		super.fillStructure();
		setRequired(true);
		attrId.setReadOnly(true);
		complexStructure.add(name);
		attributes.add(name);
		complexStructure.add(execClass);
		attributes.add(execClass);
	}

	/**
	 * Overrides super-class method to realize this class specific writting to
	 * XML file.
	 */
	public void toXML(Node parent) throws DOMException {
		complexStructure.remove(0);
		super.toXML(parent);
		complexStructure.add(0, attrId);
	}

	public void fromXML(Node node) {
		attrType.setValue("");
		super.fromXML(node);
	}

	/**
	 * Called after importing of XML file to set the proper Application objects
	 * for Tool references, and proper DataField objects for ActualParameters
	 * references, according on it's IDs read from XML.
	 */
	protected void afterImporting() {
		// setting choosen application
		String wantedAppID = attrId.toValue().toString();
		Iterator it = definedApplications.getChoosable().iterator();
		while (it.hasNext()) {
			Application app = (Application) it.next();
			if (app.getID().equals(wantedAppID)) {
				helperElement.setValue(app);
				break;
			}
		}
		// setting choosen data fields
		it = refActualParameters.toCollection().iterator();
		while (it.hasNext()) {
			ActualParameter ap = (ActualParameter) it.next();
			ap.afterImporting();
		}
	}

	/**
	 * Uses a trick to set the cloned instance of actual parameters to be
	 * edited, so that canceling of changes to the actual parameter collection
	 * can be handled - the real instance of actual parameters is set to the
	 * cloned instance within the isValidData method.
	 */
	public XMLPanel getPanel() {
		XMLPanel p = new XMLGroupPanel(this,
				new XMLElement[] { name, execClass }, toLabel());
		return p;
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		Service t = (Service) super.clone();

		t.name = (XMLAttribute) this.name.clone();
		t.execClass = (XMLAttribute) this.execClass.clone();
		t.fillStructure();
		return t;
	}
	 public com.ds.bpm.bpd.xml.elements.Package getPackage () {
	      return definedApplications.getPackage();
	   }
}

/* End of Tool.java */
