/* XMLInterface.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml;

import java.util.Collection;
import java.util.Map;

import com.ds.bpm.bpd.xml.elements.Package;

/**
* Class which purpose is to provide methods which are
* used by classes that represents program apstraction of
* XML elements. These methods offers support for reading or
* writting an XML document.
*/
public interface XMLInterface {

   void setValidation(boolean isActive);

   public void clearParserErrorMessages();

   /**
    * This method has to be called from the newly created package after its
    * Id is entered.
    * @param pkg
    */
   public void register(Package pkg);

   /**
    * This method is called when first saving new package, or when saving it with
    * a different name.
    * @param filename
    * @param pkg
    */
   public void registerPackageFilename(String filename, Package pkg);

   public boolean isPackageOpened(String pkgId);

   public void putPkgIdToFileContentMapping(String pkgId, String fileContent);

   public String getPackageFileContent(String pkgId);

   public Package getPackageById(String pkgId);

   public Package getPackageByFilename(String filename);

   public Package getExternalPackageByRelativeFilePath(
           String relativePathToExtPkg, Package rootPkg);

   public String getAbsoluteFilePath(Package pkg);

   public Collection getAllPackages();

   public Collection getAllPackageIds();

   public Collection getAllPackageFilenames();

   public boolean doesPackageFileExists(String xmlFile);

   public String getParentDirectory(Package pkg);

   public Package openPackage(String pkgReference, boolean openFromStream);

   public Package parseDocument(String toParse, boolean isFile);

   /**
    * This method should be called immediatelly after opening a document,
    * otherwise, messages could be invalid.
    * @return The map which keys are opened packages, and values are the sets
    * of errors for corresponding package.
    */
   public Map getParsingErrorMessages();

   public void closePackage(String pkgId);

   public void closeAllPackages();

   public String getIDFromFile(String xmlFile);

}

