/*
 * Created on 2004-2-23
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.process;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.*;
import com.ds.bpm.bpd.xml.panels.XMLTableControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLTablePanel;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class XMLProcessTableControlPanel extends XMLTableControlPanel {

    /**
     * Constructs XMLProcessFormControlPanel
     *
     * @param myOwner
     * @param title
     * @param isVertical
     * @param hasBorder
     */
    public XMLProcessTableControlPanel(XMLCollection myOwner, String title,
                                       boolean isVertical, boolean hasBorder) {
        super(myOwner, title, isVertical, hasBorder);
    }

    protected void addPerform(ActionEvent ae) {
        if (BPD.getInstance().getUserInfo() == null) {
            return;
        }
        XMLElement newElement = ((XMLCollection) getOwner())
                .generateNewElement();
        XMLElementDialog de = new XMLElementDialog(getDialog(), newElement
                .toLabel()
                + " - "
                + ResourceManager.getLanguageDependentString("DefiningKey"));
        de.editXMLElement(newElement.getPanel(), true, false);
        // if cancel hasn't been pressed
        if (!de.isCanceled()) {
            Table  table = (Table) newElement;
            if (table.hasForms()) {
                if (addElement((XMLCollectionElement) newElement)) {
                    ((XMLCollection) getOwner()).onElementCreated(newElement);
                }
            }
        }
    }

    protected void editPerform(ActionEvent ae) {
        XMLComplexElement editElement = getSelectedElement();
        if (editElement != null) {
            XMLElementDialog de = new XMLElementDialog(getDialog(), editElement
                    .toLabel()
                    + " - "
                    + ResourceManager.getLanguageDependentString("EditingKey"));
            de.editXMLElement(editElement.getPanel(), true, false);
            if (!de.isCanceled()) {
                modifyElement(editElement);
                ((XMLCollection) getOwner()).onElementModified(editElement);
            }
        } else {
            complainLoudly("WarningEmptySelectionToEditOrDelete");
        }
        ((XMLTablePanel) controlledPanel).getTable().requestFocus();
    }

    protected boolean addElement(XMLCollectionElement e) {
        Collection collection = ((XMLCollection) getOwner()).toCollection();
        boolean bExisted = false;
        for (Iterator it = collection.iterator(); it.hasNext(); ) {
            XMLCollectionElement tmp = (XMLCollectionElement) it.next();
            if (tmp.getID().equals(e.getID())) {
                bExisted = true;
                break;
            }
        }
        if (!bExisted) {
            ((XMLCollection) getOwner()).add(e);
            JTable t = ((XMLTablePanel) controlledPanel).getTable();
            DefaultTableModel dtm = (DefaultTableModel) t.getModel();
            Vector v = new Vector(e.toComplexTypeValues());
            // add object itself to the first column (it is invisible column)
            v.add(0, e);
            dtm.addRow(v);
            try {
                t.setRowSelectionInterval(t.getRowCount() - 1,
                        t.getRowCount() - 1);
            } catch (Exception ex) {
                ex.printStackTrace();
            }
            t.requestFocus();
            return true;
        } else {
            complainLoudly("Sys.Collection.isElementExisted");
        }
        return false;
    }
}
