package com.ds.bpm.bpd.plugin.impl.activity.jdsform;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.plugin.PluginElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.plugin.impl.process.Message;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.common.JDSException;
import com.ds.common.util.StringUtility;
import com.ds.common.util.XMLUtility;
import com.ds.config.BPDPlugin;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;
import com.ds.esd.tool.module.EUModule;
import com.ds.esd.tool.module.EUPackage;
import com.ds.iot.json.UserInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import java.util.*;

public class JDSForm extends PluginElement {

    public static final String FORM_NAME = "JDSFORM";

    public static final String TYPE_NAME = "APPLICATION";

    public static final String APPLICATION_NAME = "APPLICATION";

    private MDForms forms;

    private Activity act;

    private WorkflowProcess wp;


    public JDSForm(BPDPlugin plugin) {
        super(plugin);
        setLabelName(plugin.getDisplayname() == null ? "动态表单" : plugin.getDisplayname());
        forms = new MDForms(this);
        fillStructure();
    }

    protected void fillStructure() {
        complexStructure.add(forms);
    }


    public String[][] getForms() {
        String[][] forms = null;
        UserInfo user = BPD.getInstance().getUserInfo();
        if (user != null) {
            try {
                Project project = ESDFacrory.getESDClient().getProjectByName(wp.getProjectName());
                EUPackage euPackage = project.getActiveProjectVersion().getPackageByPath("form");
                Set<EUModule> modules = new HashSet<>();
                if (euPackage != null) {
                    modules = euPackage.listModules();
                }
                forms = new String[modules.size()][3];
                int k = 0;
                for (EUModule module : modules) {
                    forms[k][0] = Utils.filterNull(module.getComponent().getTitle() == null ? module.getComponent().getAlias() : module.getComponent().getTitle());
                    forms[k][1] = Utils.filterNull(StringUtility.replace(module.getClassName(), ".", "_"));
                    forms[k][2] = Utils.filterNull(module.getClassName());
                    k = k + 1;
                }
            } catch (JDSException e) {
                e.printStackTrace();
            }
        }
        return forms;
    }


    public void toXML(Node parent) {
        clearOldXML();

        Element easElem = (Element) XMLUtility.getFirstChild(parent,
                "ExtendedAttributes");
        Document doc = parent.getOwnerDocument();

        if (easElem == null) {
            easElem = doc.createElement("ExtendedAttributes");
            parent.appendChild(easElem);
        }

        for (Iterator iter = complexStructure.iterator(); iter.hasNext(); ) {
            XMLElement element = (XMLElement) iter.next();
            element.toXML(easElem);
        }


    }


    public void clearOldXML() {
        ExtendedAttributes exAttrs = null;
        if (act != null) {
            exAttrs = (ExtendedAttributes) act.get("ExtendedAttributes");
            Set easToRemove = new HashSet();
            Iterator it = exAttrs.toCollection().iterator();
            String nm = "";
            String val = "";
            while (it.hasNext()) {
                ExtendedAttribute ea = (ExtendedAttribute) it.next();
                nm = ea.get("Name").toValue().toString();
                if (nm.startsWith(JDSForm.FORM_NAME)) {
                    easToRemove.add(ea);
                }
            }
            exAttrs.toCollection().removeAll(easToRemove);
        }

    }


    public void afterImporting() throws PluginException {
        Object obj = getProperty("Activity");
        if (obj == null) {
            throw new PluginException(Message
                    .getLanguageDependentString("Plugin.Initialize.Error"));
        }
        act = (Activity) obj;
        ExtendedAttributes exAttrs = (ExtendedAttributes) act
                .get("ExtendedAttributes");
        Set easToRemove = new HashSet();
        Iterator it = exAttrs.toCollection().iterator();
        String nm = "";
        String val = "";
        List wpForms = new ArrayList();
        while (it.hasNext()) {
            ExtendedAttribute ea = (ExtendedAttribute) it.next();
            nm = ea.get("Name").toValue().toString();
            val = ea.get("Value").toValue().toString();
            if (nm.startsWith(JDSForm.FORM_NAME)) {
                easToRemove.add(ea);
                if (!nm.equalsIgnoreCase(JDSForm.FORM_NAME)) {
                    wpForms.add(ea);
                }
            }
        }
        exAttrs.toCollection().removeAll(easToRemove);
        ((MDForms) forms).afterImporting(wpForms);
    }


    public Object clone() {
        JDSForm af = (JDSForm) super.clone();
        af.forms = (MDForms) this.forms.clone();
        af.fillStructure();

        return af;
    }

    public boolean isValidEnter(XMLPanel p) {

        //getDefForms(true);
        return true;
    }

    public void loadProperties() throws PluginException {
        Object obj = getProperty("Activity");
        if (obj == null) {
            act = null;

        } else {
            act = (Activity) obj;
        }
        Object wpObj = getProperty("WorkflowProcess");
        wp = (WorkflowProcess) wpObj;
    }

    public String getDefId() {
        if (act == null) {
            return wp.getID();
        }
        return act.getID();
    }

    public WorkflowProcess getWp() {
        return wp;
    }

    public void setWp(WorkflowProcess wp) {
        this.wp = wp;
    }
}