/*
 * Created on 2004-2-23
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.activity.jdsform;

import com.ds.bpm.bpd.plugin.PluginElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.common.util.XMLUtility;
import com.ds.config.BPDPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import java.util.*;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 流程启动附件插件类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 *
 * @author Huchm 2004-2-23 0:57:44
 * @version 1.0
 */
public class AttachmentPlugin extends PluginElement {

    public static final String FORM_NAME = "ATTACHEMENTDEF";


    public static final String TYPE_NAME = "APPLICATION";

    // 主附件
    private XMLElement attachments;

    // 流程对象
    private Activity at;


    // 构造器
    public AttachmentPlugin(BPDPlugin plugin) {
        super(plugin);
        attachments = new AttachmentDefs(this);
        // 初始化页面显示属性
        setLabelName("附件管理");
        fillStructure();

    }

    protected void fillStructure() {
        super.fillStructure();
        complexStructure.add(attachments);
    }


    public void toXML(Node parent) {
        Element easElem = (Element) XMLUtility.getFirstChild(parent,
                "ExtendedAttributes");
        Document doc = parent.getOwnerDocument();
        if (easElem == null) {
            easElem = doc.createElement("ExtendedAttributes");
            parent.appendChild(easElem);
        }
        for (Iterator iter = complexStructure.iterator(); iter.hasNext(); ) {
            XMLElement element = (XMLElement) iter.next();
            element.toXML(easElem);
        }
    }


    public void afterImporting() throws PluginException {
        Object obj = getProperty("Activity");
        if (obj == null) {
            throw new PluginException(Message
                    .getLanguageDependentString("Plugin.Initialize.Error"));
        }
        at = (Activity) obj;
        ExtendedAttributes exAttrs = (ExtendedAttributes) at
                .get("ExtendedAttributes");
        Set easToRemove = new HashSet();
        Iterator it = exAttrs.toCollection().iterator();
        String nm = "";
        String val = "";
        List wpForms = new ArrayList();
        while (it.hasNext()) {
            ExtendedAttribute ea = (ExtendedAttribute) it.next();
            nm = ea.get("Name").toValue().toString();

            val = ea.get("Value").toValue().toString();
            if (nm.startsWith(AttachmentPlugin.FORM_NAME)) {
                easToRemove.add(ea);
                if (!nm.equalsIgnoreCase(AttachmentPlugin.FORM_NAME)) {
                    wpForms.add(ea);
                }
            }
        }
        exAttrs.toCollection().removeAll(easToRemove);
        ((AttachmentDefs) attachments).afterImporting(wpForms);
    }

    // 实现clone方法
    public Object clone() {
        AttachmentPlugin pf = (AttachmentPlugin) super.clone();
        pf.attachments = (XMLElement) this.attachments.clone();
        pf.fillStructure();
        return pf;
    }
}
