/*
 * Created on 2004-2-23
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.activity.jdsform;

import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 附件管理
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-2-23 1:05:21
 * @version 1.0
 */
public class AttachmentDef extends XMLCollectionElement {

	// 附件名称
	private XMLElement attrName = new XMLAttribute("Value");
	
	//英文名称
	private XMLElement attrEnName = new XMLAttribute("enName");

	// 附件描述
	private XMLAttribute attrDesc = new XMLAttribute("Description");

	// WebWordButton是否可操作
	private XMLAttribute attrOperation = new XMLAttribute("Operation");

	private XMLElement form;

	// 可供配置的附件
	String[][] chooseForms;

	/**
	 * 构造器
	 * 
	 * @param myCollection
	 */
	public AttachmentDef(XMLCollection myCollection) {
		super(myCollection);
		setLabelName("附件管理");

		// 初始化页面显示信息
		// 附件ID
		attrId
				.setLabelName(Message
						.getLanguageDependentString("Process.ProcessForm.MainForm.ID.display"));
		// 附件名称
		attrName
				.setLabelName("附件名称");
		
		attrOperation.setLabelName("是否必须上传");
		attrOperation.setValue("1");
		// 附件描述
		attrDesc
				.setLabelName("附件描述");
		fillStructure();
	}

	protected void fillStructure() {
		super.fillStructure();
		complexStructure.add(attrName);
		attributes.add(attrName);
		
		
		complexStructure.add(attrOperation);
		attributes.add(attrOperation);
		
		
		complexStructure.add(attrDesc);
		attributes.add(attrDesc);
	
	}

	public XMLPanel getPanel() {

			return null;

	}

	// 实现Clone方法
	public Object clone() {
		AttachmentDef f = (AttachmentDef) super.clone();
		f.attrName = (XMLElement) this.attrName.clone();
		f.attrDesc = (XMLAttribute) this.attrDesc.clone();
		f.fillStructure();
		return f;
	}

	private String getValueFromArray(String[][] array, String id, int index) {
		String ret = "";
		for (int i = 0; i < array.length; i++) {
			String[] cell = array[i];
			if (index < 0 || index >= cell.length) {
				return "";
			}
			if (cell[1].equals(id)) {
				ret = cell[index];
				break;
			}
		}
		return ret;
	}
	
	
	
	
	public boolean hasForms() {
		return (chooseForms != null && chooseForms.length > 0);
	}

	public void toXML(Node parent) {
		Element elem = parent.getOwnerDocument().createElement(
				"ExtendedAttribute");
		elem.setAttribute("Name", AttachmentPlugin.FORM_NAME + "."
				+ attrId.toValue().toString());
		elem.setAttribute("Type", AttachmentPlugin.TYPE_NAME);
		elem.setAttribute("Value", attrName.toValue().toString() + ";"
				+ attrDesc.toValue().toString());
		parent.appendChild(elem);
	}

	public void afterImporting(Object obj) {
		if (obj instanceof ExtendedAttribute) {
			ExtendedAttribute ea = (ExtendedAttribute) obj;
			String nm = ea.get("Name").toValue().toString();
			nm = nm.substring((AttachmentPlugin.FORM_NAME + ".").length());
			if (nm.indexOf(".") == -1) {
				attrId.setValue(nm);
				String value = ea.get("Value").toValue().toString();
				String[] vs = Utils.tokenize(value, ";");
				if (vs != null && vs.length >= 2) {
					attrName.setValue(vs[0]);
					attrDesc.setValue(vs[1]);
				}
			}
		}
	}
}
