/*
 * Created on 2004-2-25
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.plugin.impl.activity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.ds.config.BPDPlugin;
import com.ds.esb.config.formula.FormulaType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ds.bpm.bpd.enums.DeviceDefEnums;
import com.ds.bpm.bpd.plugin.ExpressionElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.formula.Formulas;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;
import com.ds.bpm.enums.activitydef.deivce.ActivityDefDeviceAtt;
import com.ds.enums.EnumsUtil;

/**
 * <p>
 * Title: ISD设计工具（BPD）
 * </p>
 * <p>
 * Description: 选择执行设备
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author 文章 2018-1-5 14:13:32
 * @version 3.0
 */
public class ActivityDevice extends ExpressionElement {

    private Formulas deviceSelected = new Formulas(this, FormulaType.DeviceSelectedID);

    private XMLAttribute performType = new XMLAttribute(EnumsUtil.getAttribute(DeviceDefEnums.ActivityDefDevicePerformtype));

    private XMLAttribute performSequence = new XMLAttribute(EnumsUtil.getAttribute(DeviceDefEnums.ActivityDefDevciePerformSequence));

    private XMLAttribute intervalTime = new XMLAttribute(DeviceDefEnums.IntervalTime.getType(), DeviceDefEnums.IntervalTime.getDisplayName());

    public ActivityDevice(BPDPlugin plugin) {
	super(plugin);
	fillStructure();
    }

    protected void fillStructure() {
	super.fillStructure();
	intervalTime.setValue(0);
	complexStructure.add(deviceSelected);
	complexStructure.add(performType);
	complexStructure.add(performSequence);
	complexStructure.add(intervalTime);
    }

    // 把活动办理权限信息保存在XML文件中
    public void toXML(Node parent) {
	NodeList nodeList = ((Element) parent).getElementsByTagName("ExtendedAttributes");
	Element easElem;
	Document doc = parent.getOwnerDocument();
	if (nodeList.getLength() != 0) {
	    easElem = (Element) nodeList.item(0);
	} else {
	    easElem = doc.createElement("ExtendedAttributes");
	    parent.appendChild(easElem);
	}
	for (Iterator iter = complexStructure.iterator(); iter.hasNext();) {
	    XMLElement element = (XMLElement) iter.next();
	    if (element instanceof Formulas) {
		element.toXML(easElem);
	    } else {
		Element eaElem = doc.createElement("ExtendedAttribute");
		eaElem.setAttribute("Name", element.toName());
		eaElem.setAttribute("Type", FormulaType.DeviceSelectedID.getBaseType().getType());
		eaElem.setAttribute("Value", element.toValue().toString());
		easElem.appendChild(eaElem);
	    }
	}
    }

    // 从活动扩展属性保存到活动权限对象
    public void afterImporting() throws PluginException {
	Object obj = getProperty("Activity");
	if (obj == null) {
	    throw new PluginException(Message.getLanguageDependentString("Plugin.Initialize.Error"));
	}
	act = (Activity) obj;
	ExtendedAttributes exAttrs = (ExtendedAttributes) act.get("ExtendedAttributes");
	Set easToRemove = new HashSet();
	Iterator it = exAttrs.toCollection().iterator();
	String nm = "";
	String val = "";
	List performerSelectedList = new ArrayList();
	List readerSelectedList = new ArrayList();
	List insteadSignSelectedList = new ArrayList();
	while (it.hasNext()) {
	    ExtendedAttribute ea = (ExtendedAttribute) it.next();
	    nm = ea.get("Name").toValue().toString();
	    val = ea.get("Value").toValue().toString();

	    String type = ea.get("Type").toValue().toString();

	    if (type != null && type.equals(FormulaType.DeviceSelectedID.getBaseType().getType())) {
		if (nm.startsWith(ActivityDefDeviceAtt.DEVICESELECTEDID.getType())) {
		    performerSelectedList.add(ea);
		    easToRemove.add(ea);
		    continue;
		}

		if (nm.equalsIgnoreCase(DeviceDefEnums.ActivityDefDevicePerformtype.getType())) {
		    performType.setValue(val);
		    performType.refreshDisplayValue();
		    easToRemove.add(ea);
		    continue;
		}
		if (nm.equalsIgnoreCase(DeviceDefEnums.ActivityDefDevicePerformtype.getType())) {
		    performSequence.setValue(val);
		    performSequence.refreshDisplayValue();
		    easToRemove.add(ea);
		    continue;
		}
		if (nm.equalsIgnoreCase(DeviceDefEnums.IntervalTime.getType())) {
		    intervalTime.setValue(val);
		    intervalTime.refreshDisplayValue();
		    easToRemove.add(ea);
		    continue;
		}
	    }

	}
	deviceSelected.afterImporting(performerSelectedList);

	exAttrs.toCollection().removeAll(easToRemove);
    }

    public void setLabelName() {
	// 初始化页面显示属性
	setLabelName(Message.getLanguageDependentString("Activity.Device.display"));

	// intervalTime.setLabelName(Message.getLanguageDependentString("Activity.Device.DelayTime.display"));

    }

    public Object clone() {
	ActivityDevice ar = (ActivityDevice) super.clone();
	ar.deviceSelected = (Formulas) this.deviceSelected.clone();
	ar.performType = (XMLAttribute) this.performType.clone();
	ar.performSequence = (XMLAttribute) this.performSequence.clone();
	ar.intervalTime = (XMLAttribute) this.intervalTime.clone();
	ar.fillStructure();
	return ar;
    }

    public XMLPanel getPanel() {
	XMLPanel commonPanel = new XMLGroupPanel(this, new XMLElement[] { performType, performSequence, intervalTime }, Message.getLanguageDependentString("Activity.Device.Common.display"));
	XMLPanel performerPanel = deviceSelected.getPanel();

	return new XMLTabbedPanel(this, new XMLPanel[] { commonPanel, performerPanel });
    }
}
