
package com.ds.bpm.bpd.plugin.impl.activity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.ds.config.BPDPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ds.bpm.bpd.enums.ActivityCommandEnums;
import com.ds.bpm.bpd.plugin.ExpressionElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.CommandListeners;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.formula.Formulas;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;
import com.ds.enums.EnumsUtil;

/**
 * <p>
 * Title: ISD设计工具（BPD）
 * </p>
 * <p>
 * Description:命令控制
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author 文章 2018-1-5 14:13:32
 * @version 3.0
 */
public class ActivityCommandEvent extends ExpressionElement {

    private XMLAttribute commandTimeOut = new XMLAttribute(ActivityCommandEnums.CommandTimeOut.getType(), ActivityCommandEnums.CommandTimeOut.getDisplayName());

    private XMLAttribute commandDelayTime = new XMLAttribute(ActivityCommandEnums.CommandDelayTime.getType(), ActivityCommandEnums.CommandDelayTime.getDisplayName());

    private XMLAttribute reRryTimes = new XMLAttribute(ActivityCommandEnums.CommandRetryTimes.getType(), ActivityCommandEnums.CommandRetryTimes.getDisplayName());

    private CommandListeners listeners = new CommandListeners(this);

    private XMLAttribute commandReTryType = new XMLAttribute(EnumsUtil.getAttribute(ActivityCommandEnums.CommandReTryType));

    private XMLAttribute durationUnit = new XMLAttribute(EnumsUtil.getAttribute(ActivityCommandEnums.DurationUnit));

    // min=0
    private ExtendedAttributes refExtendedAttributes = new ExtendedAttributes(this);

    public ActivityCommandEvent(BPDPlugin plugin) {
	super(plugin);
	fillStructure();
    }

    public WorkflowProcess getProcess() {
	return wp;
    }

    protected void fillStructure() {
	super.fillStructure();
	commandTimeOut.setValue(60);
	reRryTimes.setValue(3);
	commandDelayTime.setValue(0);
	complexStructure.add(commandDelayTime);
	complexStructure.add(commandTimeOut);
	complexStructure.add(commandReTryType);
	complexStructure.add(durationUnit);
	complexStructure.add(refExtendedAttributes);
	complexStructure.add(reRryTimes);

	// }
	ExtendedAttribute ea;
	// 把监听器属性加到扩展属性
	ea = new ExtendedAttribute(refExtendedAttributes);
	ea.get("Value").setRequired(false);
	ea.set("Name", "CommandListeners");
	ea.setAnyXMLCollection(listeners);

	((ArrayList) refExtendedAttributes.toCollection()).add(ea);

    }

    // 把活动办理权限信息保存在XML文件中
    public void toXML(Node parent) {
	NodeList nodeList = ((Element) parent).getElementsByTagName("ExtendedAttributes");
	Element easElem;
	Document doc = parent.getOwnerDocument();
	if (nodeList.getLength() != 0) {
	    easElem = (Element) nodeList.item(0);
	} else {
	    easElem = doc.createElement("ExtendedAttributes");
	    parent.appendChild(easElem);
	}

	for (Iterator iter = complexStructure.iterator(); iter.hasNext();) {
	    XMLElement element = (XMLElement) iter.next();
	    if (element instanceof Formulas) {
		element.toXML(easElem);
	    } else {
		Element eaElem = doc.createElement("ExtendedAttribute");
		eaElem.setAttribute("Name", element.toName());
		eaElem.setAttribute("Value", element.toValue().toString());
		easElem.appendChild(eaElem);
	    }
	}

	listeners.toXML(easElem);
    }

    // 从活动扩展属性保存到活动权限对象
    public void afterImporting() throws PluginException {
	Object obj = getProperty("Activity");
	if (obj == null) {
	    throw new PluginException(Message.getLanguageDependentString("Plugin.Initialize.Error"));
	}
	act = (Activity) obj;
	ExtendedAttributes exAttrs = (ExtendedAttributes) act.get("ExtendedAttributes");
	Set easToRemove = new HashSet();
	Iterator it = exAttrs.toCollection().iterator();
	String nm = "";
	String val = "";
	List commandSelectedList = new ArrayList();

	while (it.hasNext()) {
	    ExtendedAttribute ea = (ExtendedAttribute) it.next();
	    nm = ea.get("Name").toValue().toString();
	    val = ea.get("Value").toValue().toString();
	    if (nm.startsWith("COMMANDSELECTEDID".toUpperCase())) {
		commandSelectedList.add(ea);
		easToRemove.add(ea);
		continue;
	    }

	    if (nm.equals(ActivityCommandEnums.CommandTimeOut.getType())) {
		commandTimeOut.setValue(val);
		commandTimeOut.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }
	    

	    if (nm.equals(ActivityCommandEnums.CommandDelayTime.getType())) {
		commandDelayTime.setValue(val);
		commandDelayTime.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }
	    if (nm.equals(ActivityCommandEnums.CommandRetryTimes.getType())) {
		reRryTimes.setValue(val);
		reRryTimes.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }
	    if (nm.equals(ActivityCommandEnums.CommandReTryType.getType())) {
		commandReTryType.setValue(val);
		commandReTryType.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }

	    if (nm.equals(ActivityCommandEnums.DurationUnit.getType())) {
		durationUnit.setValue(val);
		durationUnit.refreshDisplayValue();
		easToRemove.add(ea);
		continue;
	    }

	}
	listeners.afterImporting();
	exAttrs.toCollection().removeAll(easToRemove);
    }

    public void setLabelName() {
	// 初始化页面显示属性
	setLabelName(this.getBpdElement().getDisplayname());

	// commandSelected.setLabelName(Message.getLanguageDependentString("Activity.Command.CommandSelectedID.display"));
	// commandDelayTime.setLabelName(Message.getLanguageDependentString("Activity.Command.DelayTime.display"));
	// reRryTimes.setLabelName(Message.getLanguageDependentString("Activity.Command.RetryTimes.display"));

    }

    public Object clone() {

	ActivityCommandEvent ar = (ActivityCommandEvent) super.clone();
	ar.commandDelayTime = (XMLAttribute) this.commandDelayTime.clone();
	ar.commandTimeOut = (XMLAttribute) this.commandTimeOut.clone();
	ar.reRryTimes = (XMLAttribute) this.reRryTimes.clone();
	ar.commandReTryType = (XMLAttribute) this.commandReTryType.clone();
	ar.durationUnit = (XMLAttribute) this.durationUnit.clone();
	ar.reRryTimes = (XMLAttribute) this.reRryTimes.clone();
	ar.listeners = (CommandListeners) this.listeners.clone();
	ar.fillStructure();
	return ar;
    }

    public XMLPanel getPanel() {
	XMLGroupPanel commonPanel = new XMLGroupPanel(this, new XMLElement[] {commandDelayTime, commandTimeOut, reRryTimes, commandReTryType }, "监听配置");
	return new XMLTabbedPanel(this, new XMLPanel[] { commonPanel, listeners.getPanel() });
    }
}
