package com.ds.bpm.bpd.plugin.impl;

import com.ds.bpm.bpd.plugin.ExpressionElement;
import com.ds.bpm.bpd.plugin.PluginException;
import com.ds.bpm.bpd.plugin.impl.process.Forms;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.ExtendedAttribute;
import com.ds.bpm.bpd.xml.elements.ExtendedAttributes;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.formula.Formulas;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;
import com.ds.bpm.enums.safe.SecretEnums;
import com.ds.bpm.enums.safe.ShareEnums;
import com.ds.common.util.XMLUtility;
import com.ds.config.BPDPlugin;
import com.ds.enums.EnumsUtil;
import com.ds.enums.attribute.Attributetype;
import com.ds.esb.config.formula.FormulaType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import java.util.*;

public class SafePlugin extends ExpressionElement {

    List cloneComplexStructure = new ArrayList();

    // 传阅人选择条件
    protected Formulas safeID = new Formulas(this, FormulaType.SafeID);

    public SafePlugin(BPDPlugin plugin) {
        super(plugin);
        setLabelName("安全设定");
        fillStructure();
    }
//
//    SafePlugin(List complexStructure) {
//        this.cloneComplexStructure = complexStructure;
//    }

    protected void fillStructure() {
        super.fillStructure();
        if (cloneComplexStructure == null || cloneComplexStructure.isEmpty()) {
            ShareEnums[] shareEnums = ShareEnums.values();
            for (ShareEnums shareEnum : shareEnums) {
                complexStructure.add(new XMLAttribute(EnumsUtil.getAttribute(shareEnum)));
            }
            SecretEnums[] secretEnums = SecretEnums.values();
            for (SecretEnums secretEnum : secretEnums) {
                complexStructure.add(new XMLAttribute(EnumsUtil.getAttribute(secretEnum)));
            }
        } else {
            complexStructure = cloneComplexStructure;
        }

    }

    public void fillCom(List complexStructure) {
        cloneComplexStructure = complexStructure;
    }

    public void toXML(Node parent) {
        Element easElem = (Element) XMLUtility.getFirstChild(parent,
                "ExtendedAttributes");
        Document doc = parent.getOwnerDocument();
        if (easElem == null) {
            easElem = doc.createElement("ExtendedAttributes");
            parent.appendChild(easElem);
        }

        for (Iterator iter = complexStructure.iterator(); iter.hasNext(); ) {
            XMLElement element = (XMLElement) iter.next();
            if (element instanceof Formulas || element instanceof Forms) {
                element.toXML(easElem);
            } else {
                Element eaElem = doc.createElement("ExtendedAttribute");
                eaElem.setAttribute("Name", element.toName());
                eaElem.setAttribute("Value", element.toValue().toString());
                eaElem.setAttribute("Type", Attributetype.SAFE.getType());
                easElem.appendChild(eaElem);
            }
        }
        safeID.toXML(easElem);
    }


    public XMLAttribute getXMLAttributeByName(String name) {
        Iterator it = complexStructure.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof XMLAttribute) {
                XMLAttribute att = (XMLAttribute) obj;
                if (name.equalsIgnoreCase(att.toName())) {
                    return att;
                }
            }
        }
        return null;

    }

    // 从活动扩展属性保存到活动权限对象
    public void afterImporting() throws PluginException {

        Object wpObj = getProperty("WorkflowProcess");
        if (wpObj == null) {
            throw new PluginException(com.ds.bpm.bpd.plugin.impl.activity.Message.getLanguageDependentString("Plugin.Initialize.Error"));
        }
        wp = (WorkflowProcess) wpObj;

        Object obj = getProperty("Activity");
        if (obj != null) {
            act = (Activity) obj;

            ExtendedAttributes exAttrs = (ExtendedAttributes) act.get("ExtendedAttributes");
            Set easToRemove = new HashSet();
            Iterator it = exAttrs.toCollection().iterator();
            String nm = "";
            String val = "";
            List commandSelectedList = new ArrayList();
            List saves = new ArrayList();

            while (it.hasNext()) {
                ExtendedAttribute ea = (ExtendedAttribute) it.next();
                nm = ea.get("Name").toValue().toString();
                val = ea.get("Value").toValue().toString();

                if (nm.startsWith(Attributetype.SAFE.getType())) {
                    commandSelectedList.add(ea);
                    easToRemove.add(ea);
                    continue;
                }

                XMLAttribute attribute = this.getXMLAttributeByName(nm);
                if (attribute != null) {
                    attribute.setValue(val);
                    attribute.refreshDisplayValue();
                    easToRemove.add(ea);
                    continue;
                }
            }
            exAttrs.toCollection().removeAll(easToRemove);
        }
    }


    public void setLabelName() {
        // 初始化页面显示属性
        setLabelName(this.getBpdElement().getDisplayname());
    }

    public Object clone() {
        SafePlugin ar = new SafePlugin(this.getBpdElement());
        ar.fillStructure();
        return ar;
    }

    public XMLPanel getPanel() {

        List shareComplexStructure = new ArrayList();
        List secretComplexStructure = new ArrayList();

        List<String> shareEnumsList = new ArrayList<>();

        for (ShareEnums shareEnum : ShareEnums.values()) {
            shareEnumsList.add(shareEnum.getName());
        }

        List<String> secretEnumsList = new ArrayList<>();//Arrays.asList(SecretEnums.values());


        for (SecretEnums secretEnum : SecretEnums.values()) {
            secretEnumsList.add(secretEnum.getName());
        }

        for (Object obj : complexStructure) {
            XMLAttribute attribute = (XMLAttribute) obj;
            if (attribute.getEnumsAttribute() != null) {


                if (shareEnumsList.contains(attribute.getEnumsAttribute().getName())) {
                    shareComplexStructure.add(attribute);
                } else if (secretEnumsList.contains(attribute.getEnumsAttribute().getName())) {
                    secretComplexStructure.add(attribute);
                }
            }
        }

        XMLPanel secretPanel = new XMLGroupPanel(this, secretComplexStructure.toArray(), "安全设置");
        XMLPanel sharePanel = new XMLGroupPanel(this, shareComplexStructure.toArray(), "分享设置");
        return new XMLTabbedPanel(this, new XMLPanel[]{secretPanel, sharePanel, safeID.getPanel()});
    }
}
