/* ValidationErrorDisplay.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：显示工作流合法性检查报告类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2004-02-03
 *
 */

package com.ds.bpm.bpd.misc;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BarFactory;
import com.ds.bpm.bpd.Utils;
import com.ds.common.util.IOUtility;
import org.htmlparser.Parser;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.tags.InputTag;
import org.htmlparser.util.ParserException;

import javax.swing.*;
import javax.swing.text.html.FormView;
import javax.swing.text.html.HTML;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.URI;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;


/**
 * Dialog class that displays graph's validation error messages. Object of this
 * class is created by passing a Maps and the List with error messages to the
 * constructor (along with other required parameters). Keys of given
 * <code>Map</code>s are elements of the graph that didn't pass validation,
 * and values are error messages for that elements.
 */
public class ValidationErrorDisplay extends JDialog {
    private boolean stopped = false;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private WindowListener wl = new WindowAdapter() {
        public void windowClosing(WindowEvent e) {
            stopped = true;
        }
    };
    protected JMenuBar menubar;
    protected BarFactory barFactory = new BarFactory(BPD.getInstance().getPackageEditor());
    private Parser parser;
    private JEditorPane jEditorPane;
    private Page p;
    private JScrollPane sp;
    public static Map vcMap = new HashMap();

    /**
     * Constructs dialog with a given errors, and with a frame as a parent.
     */
    public ValidationErrorDisplay(Map parsingErrors, Map connectionErrors,
                                  java.util.List basicGraphConformanceErrors,
                                  Map graphConformanceErrors, Map logicErrors, JFrame parentFrame,
                                  String title, boolean controlsVisible) {
        super(parentFrame, title, true);

        showDialog(parsingErrors, connectionErrors,
                basicGraphConformanceErrors, graphConformanceErrors,
                logicErrors, parentFrame, controlsVisible);
    }

    /**
     * Constructs dialog with a given errors, and with a dialog as a parent.
     */
    public ValidationErrorDisplay(Map parsingErrors, Map connectionErrors,
                                  java.util.List basicGraphConformanceErrors,
                                  Map graphConformanceErrors, Map logicErrors, JDialog parentDialog,
                                  String title, boolean controlsVisible) {
        super(parentDialog, title, true);
        showDialog(parsingErrors, connectionErrors,
                basicGraphConformanceErrors, graphConformanceErrors,
                logicErrors, parentDialog, controlsVisible);
    }

    public static ValidationErrorDisplay getValidationErrorDisplay(Page p) {

        return (ValidationErrorDisplay) vcMap.get(p);
    }


    public void updatePanel(String html) {

        jEditorPane.setText(html);
        jEditorPane.setContentType("text/html");

        initjEditorPane(html);
    }


    /**
     * Shows error messages in a <code>JEditorPane</code> component.
     */
    protected void showDialog(Map parsingErrors, Map connectionErrors,
                              java.util.List basicGraphConformanceErrors,
                              Map graphConformanceErrors, Map logicErrors, Window parentWindow,
                              boolean controlsVisible) {


        String name = BPD.getInstance().openDialog(
                "打开表单模板");
        File f = new File(name);
        URI uri = f.toURI();
        this.jEditorPane = null;
        String htmlString = null;
        FileInputStream inputStream = null;

        try {
            inputStream = new FileInputStream(f);
            htmlString = IOUtility.toString(inputStream);
            IOUtility.shutdownStream(inputStream);

        } catch (FileNotFoundException e1) {
            e1.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        JPanel mainJPanel = new JPanel();

        jEditorPane = new JEditorPane("text/html", htmlString);
        JEditorPane jEditorPaneText = new JEditorPane("html/text", htmlString);
        jEditorPane.setEditable(false);
        jEditorPane.getCaret().setDot(0);
        this.sp = new JScrollPane(jEditorPane);
        //jEditorPaneText.setMaximumSize(new Dimension(200,200));
        //sp.add(jEditorPane);
        JSplitPane graphMainsplitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT,
                jEditorPane, jEditorPaneText);


        sp.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        //sp.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        getContentPane().setLayout(new BorderLayout());
        //getContentPane().add(sp,BorderLayout.CENTER);
        Hashtable menuItems = new Hashtable();
        menubar = barFactory.createMenubar();
        //JPanel jpanel=new JPanel();
        //jpanel.add(menubar, BorderLayout.NORTH);
        //getContentPane().add(menubar, BorderLayout.NORTH);

        mainJPanel.add(menubar, BorderLayout.NORTH);
        mainJPanel.add(sp, BorderLayout.CENTER);
        mainJPanel.add(jEditorPaneText, BorderLayout.SOUTH);

        getContentPane().add(graphMainsplitPane);
        initjEditorPane(htmlString);

        Utils.center(this, 100, 150);
        addWindowListener(wl);
        show();
    }

    public void initjEditorPane(String htmlString) {

        InputStream stream = null;
        try {
            stream = new ByteArrayInputStream(htmlString.getBytes(DEFAULT_CHARSET));
            this.p = new Page(stream, DEFAULT_CHARSET);
        } catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }

        this.parser = new Parser(new Lexer(p));
        vcMap.put(p, this);
        Component[] containers = jEditorPane.getComponents();
        for (int j = 0; containers.length > j; j++) {
            Container container = (Container) containers[j];
            Component[] components = container.getComponents();
            for (int i = 0; components.length > i; i++) {
                Component component = components[i];
                component.addMouseListener(new MouseListener() {

                    public void mouseClicked(MouseEvent e) {
                        parser.reset();
                        JTextField jtextField = (JTextField) e.getComponent();
                        ActionListener[] actionListeners = (ActionListener[]) jtextField.getActionListeners();
                        FormView formView = (FormView) actionListeners[0];
                        String name = (String) formView.getAttributes().getAttribute(HTML.Attribute.NAME);
                        JEditorPane parent = (JEditorPane) jtextField.getParent().getParent();
                        InputTag inputTag = null;
                        try {
                            inputTag = getInputTag(name);
                        } catch (ParserException e1) {
                            e1.printStackTrace();
                        }
                        //inputTag.getAttributes().
                        //FORMFieldMultiAttributePanel formFieldMultiAttributePanel=new FORMFieldMultiAttributePanel(inputTag,"test",null);
//						formFieldMultiAttributePanel.getPanel();
//						XMLElementDialog d = new XMLElementDialog((JFrame) BPD
//								.getInstance().getPackageEditor().getWindow(),					
//								"test");
//						d.editXMLElement(formFieldMultiAttributePanel.getPanel(), true, false);

                        System.out.print(inputTag);
                    }

                    public void mouseEntered(MouseEvent e) {
                    }

                    public void mouseExited(MouseEvent e) {
                    }

                    public void mousePressed(MouseEvent e) {
                    }

                    public void mouseReleased(MouseEvent e) {
                    }
                });
            }
        }
    }

    public InputTag getInputTag(String tagName) throws ParserException {

//		Node[] htmlTags= parser.extractAllNodesThatAre(InputTag.class);		
//		for (int i = 0; i < htmlTags.length; i++) {
//			InputTag inputTag = (InputTag) htmlTags[i];		
//			String originalTag = inputTag.toHtml();		
//			Hashtable ht = inputTag.getAttributes();
//			String name = (String) ht.get("NAME");
//			if (name.equals(tagName)){
//				
//				//
//				return inputTag;
//			}
//		}
        //parser.reset();
        return null;


    }

    public boolean hasBeenStoped() {
        return stopped;
    }

}

/* End of ValidationErrorDisplay.java */
