package com.ds.bpm.bpd.misc;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.tree.TreeNode;

import com.ds.iot.Area;
import com.ds.iot.Place;

public class PlaceTree {

    private TreeNode root;

    /**
     * @param places
     */
    public PlaceTree(List<Place> places) {
        Map<String, OrgTreeNode> map = new HashMap<String, OrgTreeNode>();
        root = new OrgTreeNode();

        for (Place place : places) {
            map.put(place.getPlaceid(), new OrgTreeNode(place));
        }

        for (Place place : places) {
            if (place != null) {
                OrgTreeNode node = (OrgTreeNode) map.get(place.getPlaceid());
                if (node.getParent() == null) {
                    insertNodeInto(node, (OrgTreeNode) root);
                } else {
                    insertNodeInto(node, (OrgTreeNode) map.get(place.getParentId()));
                }


                List<Area> areas = place.getAreas();

                for (Area area : areas) {
                    insertNodeInto(new OrgTreeNode(area), (OrgTreeNode) map.get(place.getParentId()));
                }

            }

        }

    }

    /**
     * @param parent
     * @param index
     * @return
     */
    public TreeNode getChild(TreeNode parent, int index) {
        return ((TreeNode) parent).getChildAt(index);
    }

    public Enumeration getChildren(TreeNode parent) {
        return parent.children();
    }

    public int getChildCount(TreeNode parent) {
        return parent.getChildCount();
    }

    public boolean isLeaf(TreeNode node) {
        return node.isLeaf();
    }

    public void insertNodeInto(OrgTreeNode newChild, OrgTreeNode parent, int index) {
        if (newChild == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("parent is null");
        }

        parent.insert(newChild, index);
    }

    public void insertNodeInto(OrgTreeNode newChild, OrgTreeNode parent) {
        if (newChild == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("parent is null");
        }

        parent.insert(newChild);
    }

    public void removeNodeFromParent(OrgTreeNode node) {
        OrgTreeNode parent = (OrgTreeNode) node.getParent();
        if (parent == null)
            throw new IllegalArgumentException("node does not have a parent.");

        parent.remove(node);
    }

    public TreeNode getRoot() {
        return root;
    }

    /**
     * @param root The root to set.
     */
    public void setRoot(TreeNode root) {
        this.root = root;
    }

}
