/* ExternalProcesses.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.misc;

import java.util.Collection;

import com.ds.bpm.bpd.xml.XMLComplexChoice;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.WorkflowProcesses;

// This is not a real WfMC DTD element, but it is introduced to help
public class ExternalProcesses extends XMLComplexElement {
	public ExternalProcesses(final com.ds.bpm.bpd.xml.elements.Package p) {

		super();

		WorkflowProcess[] wpA;
		final WorkflowProcesses wps = (WorkflowProcesses) p
				.get("WorkflowProcesses");
		Collection ewps = wps.getExternalWorkflowProcesses();
		wpA = new WorkflowProcess[ewps.size()];
		ewps.toArray(wpA);
		XMLComplexChoice workflows = new XMLComplexChoice("Process", wpA, 0,
				true, true, false, false, false);
		complexStructure.add(workflows);
	}

	public String toString() {
		String toRet = XMLUtil.getLanguageDependentString("ExternalKey");
		if (toRet != null) {
			return toRet;
		} else {
			return "";
		}
	}
}
