package com.ds.bpm.bpd.misc;


import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.client.ProcessDefVersion;
import com.ds.bpm.client.ct.CtBPMCacheManager;
import com.ds.common.JDSException;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.tool.module.EUModule;
import com.ds.esd.tool.module.EUPackage;
import com.ds.esd.tool.ui.component.Component;
import com.ds.esd.tool.ui.module.ModuleComponent;

import javax.swing.tree.TreeNode;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;

public class ESDComTree {

    private ComponentTreeNode root;


    public ESDComTree(ProjectVersion projectVersion) {

        WorkflowProcess wp = (WorkflowProcess) BPD.getInstance()
                .getActivedProcessEditor().getGraph().getPropertyObject();
        try {

            ProcessDefVersion processDefVersion = CtBPMCacheManager.getInstance().getProcessDefVersion(wp.getVersionID());
            root = new ComponentTreeNode(projectVersion);
            EUPackage euPackage = ESDFacrory.getESDClient().getPackageByPath(projectVersion.getVersionName(), "form");
            Set<EUModule> modules = euPackage.listModules();

            for (EUModule module : modules) {
                ModuleComponent moduleComponent = module.getComponent();
                if (moduleComponent != null && moduleComponent.getChildren() != null && moduleComponent.getChildren().size() > 0) {
                    ComponentTreeNode node = new ComponentTreeNode(moduleComponent);
                    node.setLeaf(false);
                    addComNode(node, moduleComponent.getChildren());
                    insertNodeInto(node, root);

                }
            }


        } catch (JDSException e) {
            e.printStackTrace();
        }
    }

    void addComNode(ComponentTreeNode parentNode, List<Component> components) {
        for (Component childCom : components) {
            if (childCom != null) {
                if (childCom.getChildren() != null && childCom.getChildren().size() > 0) {
                    ComponentTreeNode childNode = new ComponentTreeNode(childCom);
                    insertNodeInto(childNode, parentNode);
                    childNode.setLeaf(false);
                    addComNode(childNode, childCom.getChildren());
                }
            }
        }
    }

    /**
     * @param parent
     * @param index
     * @return
     */
    public TreeNode getChild(TreeNode parent, int index) {
        return ((TreeNode) parent).getChildAt(index);
    }

    public Enumeration getChildren(TreeNode parent) {
        return parent.children();
    }

    public int getChildCount(TreeNode parent) {
        return parent.getChildCount();
    }

    public boolean isLeaf(TreeNode node) {
        return node.isLeaf();
    }

    public void insertNodeInto(ComponentTreeNode newChild, ComponentTreeNode parent, int index) {
        if (newChild == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("parent is null");
        }

        parent.insert(newChild, index);
    }

    public void insertNodeInto(ComponentTreeNode newChild, ComponentTreeNode parent) {
        if (newChild == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("parent is null");
        }

        parent.insert(newChild);
    }

    public void removeNodeFromParent(ComponentTreeNode node) {
        ComponentTreeNode parent = (ComponentTreeNode) node.getParent();
        if (parent == null)
            throw new IllegalArgumentException("node does not have a parent.");

        parent.remove(node);
    }

    public ComponentTreeNode getRoot() {
        return root;
    }

    /**
     * @param root The root to set.
     */
    public void setRoot(ComponentTreeNode root) {
        this.root = root;
    }

}
