/*
 * Created on 2004-2-27
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.listener;

import com.ds.bpm.bpd.config.AppConfigManager;
import com.ds.bpm.bpd.xml.elements.CommandListener;
import com.ds.bpm.bpd.xml.elements.Listener;
import com.ds.config.BPDProjectConfig;
import com.ds.config.CListener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 监听器管理工具类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 *
 * @author Huchm 2004-2-27 17:16:27
 * @version 1.0
 */
public class ListenerManager {

    private static Map map = new HashMap();

    private static ListenerManager manager;
    // 应用名称
    private String appName;

    private BPDProjectConfig classification;

    private ListenerManager(String appName, String classificationName) {
        this.appName = appName;
        classification = AppConfigManager.getInstance().getApplicationMap().get(appName).getBPDProjectConfigMap().get(classificationName);
    }

    public static ListenerManager getInstance(String appName, String classification) {

        ListenerManager manager;
        if (map.get(appName + classification) != null) {
            manager = (ListenerManager) map.get(appName + classification);
        } else {
            manager = new ListenerManager(appName, classification);
            map.put(appName + classification, manager);
        }
        return manager;
    }


    // 得到流程配置监听器集
    public List getProcessListeners() {
        List list = new ArrayList();

        if (classification != null) {
            List processListeners = classification.getProcessListeners();
            for (int i = 0; i < processListeners.size(); i++) {
                CListener cl = (CListener) processListeners.get(i);
                String[] elem = new String[3];
                elem[0] = cl.getName();
                elem[1] = Listener.PROCESS_TYPE;
                elem[2] = cl.getImplementation();
                list.add(elem);
            }

        }


        return new ArrayList(list);
    }

    // 得到活动配置监听器集
    public List getActivityListeners() {
        List list = new ArrayList();

        if (classification != null) {

            List actListeners = classification.getActivityListeners();
            for (int i = 0; i < actListeners.size(); i++) {
                CListener cl = (CListener) actListeners.get(i);
                String[] elem = new String[3];
                elem[0] = cl.getName();
                elem[1] = Listener.ACTIVITY_TYPE;
                elem[2] = cl.getImplementation();
                list.add(elem);
            }

        }
        return new ArrayList(list);
    }

    //	 得到活动配置监听器集
    public List getActivityCommandListeners() {
        List list = new ArrayList();


        List actListeners = classification.getActivityListeners();
        for (int i = 0; i < actListeners.size(); i++) {
            CListener cl = (CListener) actListeners.get(i);
            String[] elem = new String[3];
            elem[0] = cl.getName();
            elem[1] = CommandListener.COMMAND_TYPE;
            elem[2] = cl.getImplementation();
            list.add(elem);
        }
        return new ArrayList(list);
    }

    // 得到路由配置监听器集
    public List getTransitionListeners() {
        List list = new ArrayList();


        List actListeners = classification.getActivityListeners();
        for (int i = 0; i < actListeners.size(); i++) {
            CListener cl = (CListener) actListeners.get(i);
            String[] elem = new String[3];
            elem[0] = cl.getName();
            elem[1] = Listener.ACTIVITY_TYPE;
            elem[2] = cl.getImplementation();
            list.add(elem);
        }
        return new ArrayList(list);
    }


    public String getAppName() {
        return appName;
    }
}
