/* TransitionView.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.graph;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

import com.ds.bpm.bpd.AbstractGraph;
import com.ds.bpm.bpd.BPDGraphModel;
import com.ds.bpm.bpd.BPDMarqueeHandler;
import com.ds.bpm.bpd.ResourceManager;

import org.jgraph.JGraph;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.PortView;

/**
 * Represents a view for a model's Transition object.
 */
public class TransitionView extends EdgeView {


   /**
    * Constructs an edge view for the specified model object.
    *
    * @param cell reference to the model object
    */
   public TransitionView(Object cell, JGraph graph, CellMapper mapper) {
      super(cell,graph,mapper);
      renderer=new TransitionRenderer();
	  
      /*int x = (int) (GraphConstants.PERMILLE / 2);
      int y = (int) (GraphConstants.PERMILLE / 100);
      Point center = new Point(x, y);
      Map map = GraphConstants.createMap();
      GraphConstants.setLabelPosition(map, center);
      GraphConstants.setAutoSize(map, true);
       this.setAttributes(map);*/
   }

   /**
    * Returns a cell handle for the view.
    */
   public CellHandle getHandle(GraphContext context) {
      return new TransitionHandle(this, context);
   }

   /**
    * Inserts a "break point" at transition object at the point where
    * popup menubar appeared.
    */
   public void addPoint (Point popupPoint) {
      boolean bendable = graph.isBendable() &&
         GraphConstants.isBendable(getAttributes());
      if (bendable) {
         int index=-1;
         int s = graph.getHandleSize();
         //Rectangle rect = graph.fromScreen(new Rectangle(popupPoint.x-s,popupPoint.y-s,2*s,2*s));
         Rectangle rect = new Rectangle(popupPoint.x-s,popupPoint.y-s,2*s,2*s);
         if (intersects(graph.getGraphics(),rect)) {
            Point point = (Point)graph.snap(new Point(popupPoint));//HM, JGraph3.4.1
            double min = Double.MAX_VALUE, dist = 0;
            for (int i = 0; i < getPointCount()-1; i++) {
               Point p = new Point((int)getPoint(i).getX(),(int)getPoint(i).getY());//HM, JGraph3.4.1
               Point p1 = new Point((int)getPoint(i+1).getX(),(int)getPoint(i+1).getY());//HM, JGraph3.4.1
               dist = new Line2D.Double(p, p1).ptLineDistSq(point);
               if (dist < min) {
                  min = dist;
                  index = i+1;
               }
            }
            if (index != -1) {
               addPoint(index,point);
               Map propertyMap = new HashMap();
               Map edgeMap=GraphConstants.cloneMap(((GraphCell)cell).getAttributes());
               GraphConstants.setPoints(edgeMap,points);
               propertyMap.put(cell,edgeMap);
               String undoMsg=ResourceManager.getLanguageDependentString("MessageAddingBreakPointAtTransition");
               ((BPDGraphModel)getModel()).insertAndEdit(null,propertyMap,null,null,null,undoMsg);
            }
         }
      }
   }

   /**
    * Inserts a "break point" programatically.
    */
   public void addPointProgramatically (Point2D popupPoint,int index) {
      if (popupPoint==null) return;
      int s = graph.getHandleSize();
      if (index<1) index=1;
      if (index>getPointCount()-1) index=getPointCount()-1;
      try {
         addPoint(index,popupPoint);
         Map propertyMap = new HashMap();
         Map edgeMap=GraphConstants.cloneMap(((GraphCell)cell).getAttributes());
         GraphConstants.setPoints(edgeMap,points);
         propertyMap.put(cell,edgeMap);
         String undoMsg=ResourceManager.getLanguageDependentString("MessageAddingBreakPointAtTransition");
         ((BPDGraphModel)getModel()).insertAndEdit(null,propertyMap,null,null,null,undoMsg);
      } catch (Exception ex) {}

   }


   /**
    * Removes a "break point" from transition at the point where
    * popup menubar appeared.
    */
   public void removePoint (Point popupPoint) {
      boolean bendable = graph.isBendable() &&
         GraphConstants.isBendable(getAttributes());
      if (bendable) {
         int index=-1;
         int s = graph.getHandleSize();
         //Rectangle rect = graph.fromScreen(new Rectangle(popupPoint.x-s,popupPoint.y-s,2*s,2*s));
         Rectangle rect = new Rectangle(popupPoint.x-s,popupPoint.y-s,2*s,2*s);
         if (intersects(graph.getGraphics(),rect)) {
            Point point = (Point)graph.snap(new Point(popupPoint));//HM, JGraph3.4.1
            double min = Double.MAX_VALUE, dist = 0;
            for (int i = 0; i < getPointCount(); i++) {
               Point p = new Point((int)getPoint(i).getX(),(int)getPoint(i).getY());//HM, JGraph3.4.1
               dist = Math.sqrt(((Point2D)point).distanceSq(p));
               if (dist < min) {
                  min = dist;
                  index = i;
               }
            }
            if (index != -1 && min<=s+2 && index!=0 && index!=getPointCount()-1) {
               removePoint(index);
               Map propertyMap = new HashMap();
               Map edgeMap=GraphConstants.cloneMap(((GraphCell)cell).getAttributes());
               GraphConstants.setPoints(edgeMap,points);
               propertyMap.put(cell,edgeMap);
               String undoMsg=ResourceManager.getLanguageDependentString("MessageRemovingBreakPointFromTransition");
               ((BPDGraphModel)getModel()).insertAndEdit(null,propertyMap,null,null,null,undoMsg);
            }
         }
      }
   }

   /**
    * Override Superclass Method so that points could
    * be added only by addPoint method.
    */
   public boolean isAddPointEvent(MouseEvent event) {
      return false;
   }

   /**
    * Override Superclass Method so that points could
    * be removed only by removePoint method.
    */
   public boolean isRemovePointEvent(MouseEvent event) {
      return false;
   }

   public static class TransitionHandle extends EdgeHandle {

      public TransitionHandle(EdgeView edge, GraphContext ctx) {
         super(edge,ctx);
      }

      public void mouseReleased(MouseEvent e) {
         try {
			 
            if (source || target) {
               Transition tr=(Transition)edge.getCell();
               PortView ss=(PortView)graph.getGraphLayoutCache().getMapping(tr.getSource(),false);
               Object tt=(PortView)graph.getGraphLayoutCache().getMapping(tr.getTarget(),false);
               PortView pvs=(PortView)edge.getSource();
               PortView pvt=(PortView)edge.getTarget();
               Activity s1=tr.getSourceActivity();
               Activity t1=tr.getTargetActivity();
               Activity s2=null;
               try {
                  s2=(Activity)((DefaultPort)pvs.getCell()).getParent();
               } catch (Exception ex) {
               }
               Activity t2=null;
               try {
                  t2=(Activity)((DefaultPort)pvt.getCell()).getParent();
               } catch (Exception ex) {
               }

               if (s2==null || t2==null) {
                  clean(tr);
                  return;
               }
               /*System.out.println("source="+source+", target="+target);
                System.out.println("S1="+s1+", T1="+t1);
                System.out.println("S2="+s2+", T2="+t2);

                System.out.println("ss="+ss.hashCode()+", tt="+tt.hashCode());
                System.out.println("ss="+ss.getClass().getName()+", tt="+tt.getClass().getName());
                System.out.println("pvs="+pvs.hashCode()+", pvt="+pvt.hashCode());*/

               if (ss!=pvs || tt!=pvt) {
                  BPDMarqueeHandler jmh=(BPDMarqueeHandler)graph.getMarqueeHandler();
				  com.ds.bpm.bpd.xml.elements.Transition uo=
                     (com.ds.bpm.bpd.xml.elements.Transition)tr.getPropertyObject();
                  if (ss!=pvs) {
                     boolean accept=
                        !(s1 instanceof Start) &&
                        !(s2 instanceof Start) &&
                        !(t1 instanceof End) &&
                        jmh.acceptsSourceOrTarget(pvs,true,pvt,false);
                     System.out.println("accept-"+accept);
                     if (!accept) {
                        clean(tr);
                        return;
                     }
                     setChanges();

                     // must set source and target activity objects after inserting into model
                     uo.setFrom(s2.getPropertyObject());
                     ((AbstractGraph)graph).getWorkflowManager().updateSplit(s2);
                     ((AbstractGraph)graph).getWorkflowManager().updateSplit(s1);
                  } else {
                     boolean accept=
                        !(t1 instanceof End) &&
                        !(t2 instanceof End) &&
                        !(s1 instanceof Start) &&
                        jmh.acceptsSourceOrTarget(pvt,false,pvs,false);
                     if (!accept) {
                        clean(tr);
                        return;
                     }
                     setChanges();

                     // must set source and target activity objects after inserting into model
                     uo.setTo(t2.getPropertyObject());
                     ((AbstractGraph)graph).getWorkflowManager().updateJoin(t2);
                     ((AbstractGraph)graph).getWorkflowManager().updateJoin(t1);
                  }
                  return;
               }
            }
            setChanges();
         } finally {
            e.consume();
         }
      }

      private void setChanges () {
         ConnectionSet cs = createConnectionSet(edge, edge.getCell(), false);
         Map nested =
            GraphConstants.createAttributes(new CellView[] { edge }, null);
         graph.getGraphLayoutCache().edit(nested, cs, null, null);
      }

      private void clean (Transition tr) {
         Graphics g = graph.getGraphics();
         overlay(g);
         firstOverlayCall=true;
         graph.removeSelectionCell(tr);
         return;
      }

   }

}

/* End of TransitionView.java */
