/* ParticipantRenderer.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：画图区域描绘类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;

import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.BPDConstants;
import com.ds.bpm.bpd.Utils;

import org.jgraph.graph.VertexRenderer;

/**
 * Class used to display participant object. It differs from other renderers
 * because the super class paint method isn't called.
 */
public class ParticipantRenderer extends VertexRenderer {

	protected static final int participantNameWidth = BPDConfig.getInstance()
			.getParticipantNameWidth();

	/**
	 * Paints participant. Overrides superclass paint to add specific painting.
	 * Basically, it draws a rectangle and vertical line, it draws it twice for
	 * selected participants. Eventually departmetns name is displayed rotated
	 * and in color to indicate selection.
	 * 
	 * @param g
	 *            Graphics to paint to
	 */
	public void paint(Graphics g) {
		String label = graph.convertValueToString(view.getCell());
		Graphics2D g2 = (Graphics2D) g;
		Dimension d = view.getBounds().getBounds().getSize();

		g2.setStroke(BPDConstants.DEPARTMENT_STROKE);

		Color bordCol = Utils.getColor(BPDConfig.getInstance()
				.getParticipantBorderColor());
		g.setColor(bordCol);

		// paint bounds
		g.drawRect(0, 0, d.width - 1, d.height - 1);

		// width of name part
		Participant p = (Participant) view.getCell();
		if (p.getUserObject() == com.ds.bpm.bpd.xml.elements.Participant
				.getFreeTextExpressionParticipant()) {
			g.setColor(Utils.getColor(BPDConfig.getInstance()
					.getFreeTextExpressionParticipantColor()));
			g.fillRect(1, 1, d.width - 3, d.height - 3);
			g.setColor(bordCol);
		} else {
			Color pc;
			String pt = "";
			if (p.get("ParticipantType") != null) {
				pt = p.get("ParticipantType").toValue().toString();
			}
			if (pt.equals("RESOURCE_SET")) {
				pc = Utils.getColor(BPDConfig.getInstance()
						.getResourceSetParticipantColor());
			} else if (pt.equals("RESOURCE")) {
				pc = Utils.getColor(BPDConfig.getInstance()
						.getResourceParticipantColor());
			} else if (pt.equals("ROLE")) {
				pc = Utils.getColor(BPDConfig.getInstance()
						.getRoleParticipantColor());
			} else if (pt.equals("ORGANIZATIONAL_UNIT")) {
				pc = Utils.getColor(BPDConfig.getInstance()
						.getOrganizationalUnitParticipantColor());
			} else if (pt.equals("HUMAN")) {
				pc = Utils.getColor(BPDConfig.getInstance()
						.getHumanParticipantColor());
			} else { // it is system participant
				pc = Utils.getColor(BPDConfig.getInstance()
						.getSystemParticipantColor());
			}

			g.setColor(pc);
			g.fillRect(1, 1, participantNameWidth - 2, d.height - 3);
			g.setColor(bordCol);
		}

		// paint vertical line
		g.drawLine(participantNameWidth, 0, participantNameWidth, d.height - 1);

		// this section paints participant in a case when object is selected
		// NOTE: hasFocus condition is removed because participant has focus
		// when any of it's children has
		/*
		 * if (selected) {// || hasFocus) {
		 * g2.setStroke(GraphConstants.SELECTION_STROKE); //if (hasFocus)
		 * g.setColor(graph.getGridColor()); //else if (selected)
		 * g.setColor(graph.getHighlightColor());
		 * g.setColor(graph.getHighlightColor()); g.drawRect(0, 0, d.width-1,
		 * d.height-1);
		 * g.drawLine(participantNameWidth,0,participantNameWidth,d.height-1); }
		 */

		// Eventually, participants (participants) name comes on. For selected
		// one label is shown in highlight color (previously set), for others
		// label color is same as for border. Translate and rotate calls set
		// the drawing origin and direction, so label is displayed sidewise and
		// vertically centered.
		if (label != null) {
			if (!selected) {
				g2.setStroke(BPDConstants.DEPARTMENT_STROKE);
				g.setColor(Utils.getColor(BPDConfig.getInstance()
						.getParticipantTextColor()));
			}
			int h = getFontMetrics(getFont()).stringWidth(label);
			h = d.height / 2 + h / 2;
			g2.translate(participantNameWidth / 2, h);
			g2.rotate(Math.toRadians(-90));
			g2.drawString(label, 0, 0);
		}
	}

}
