/* Participant.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：画图区域构造类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.graph;

import java.awt.Window;
import java.util.HashSet;
import java.util.Set;

import com.ds.bpm.bpd.AbstractGraph;
import com.ds.bpm.bpd.ProcessEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.WorkflowElement;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;

import org.jgraph.graph.DefaultGraphCell;

/**
 * Used to define Participant object in process. Participant is a container for
 * activities, subflows and other departmnet objects. Activities and subflow can
 * be moved from one to the other Participant.
 */
public class Participant extends DefaultGraphCell implements WorkflowElement {

	/**
	 * Creates participant.
	 */
	public Participant() {
		this(null);
	}

	/**
	 * Creates Participant with given userObject.
	 */
	public Participant(Object userObject) {
		super(userObject);
	}

	/**
	 * Returns true if participant is a container for any other participant.
	 */
	public boolean hasAnyParticipant() {
		for (int i = 0; i < getChildCount(); i++) {
			if (getChildAt(i) instanceof Participant) {
				return true;
			}
		}
		return false;
	}

	/**
	 * Returns the number of participant's children participants (number of
	 * participants for which it is a container).
	 */
	public int howManyChildParticipants() {
		int cd = 0;
		for (int i = 0; i < getChildCount(); i++) {
			if (getChildAt(i) instanceof Participant) {
				cd++;
			}
		}
		return cd;
	}

	/**
	 * Returns participant's children participants (participants for which it is
	 * a container).
	 */
	public Set getChildParticipants() {
		Set childParticipants = new HashSet();
		for (int i = 0; i < getChildCount(); i++) {
			Object child = getChildAt(i);
			if (child instanceof Participant) {
				childParticipants.add(child);
			}
		}
		return childParticipants;
	}

	/**
	 * Returns true if participant is a container for any activity. <BR>
	 * NOTE: subflow is a kind of activity.
	 */
	public boolean hasAnyActivity() {
		for (int i = 0; i < getChildCount(); i++) {
			if (getChildAt(i) instanceof Activity) {
				return true;
			}
		}
		return false;
	}

	/**
	 * Returns the number of participant's children activities (number of
	 * activities for which it is a container). <BR>
	 * NOTE: subflow is a kind of activity.
	 */
	public int howManyChildActivities() {
		int ca = 0;
		for (int i = 0; i < getChildCount(); i++) {
			if (getChildAt(i) instanceof Activity) {
				ca++;
			}
		}
		return ca;
	}

	/**
	 * Returns participant's children activities (activities for which it is a
	 * container). <BR>
	 * NOTE: subflow is a kind of activity.
	 */
	public Set getChildActivities() {
		Set childActivities = new HashSet();
		for (int i = 0; i < getChildCount(); i++) {
			Object child = getChildAt(i);
			if (child instanceof Activity) {
				childActivities.add(child);
			}
		}
		return childActivities;
	}

	/**
	 * Shows a dialog for editing participant properties. This is a place where
	 * undoing of property changes is realized.
	 */
	public void showPropertyDialog(Window parentWindow, AbstractGraph graph) {
		// set participant to be read-only if neccessary
		com.ds.bpm.bpd.xml.elements.Participant p = (com.ds.bpm.bpd.xml.elements.Participant) userObject;
		if (p == com.ds.bpm.bpd.xml.elements.Participant
				.getFreeTextExpressionParticipant()
				|| p.getCollection().getOwner() instanceof com.ds.bpm.bpd.xml.elements.Package) {
			p.setReadOnly(true);
		}
		XMLElementDialog xmlED = ((ProcessEditor) graph.getProcessEditor())
				.getElementEditingDialog();
		if (xmlED.isShowing()) {
			xmlED.switchPanel(getPropertyObject().getPanel(), ResourceManager
					.getLanguageDependentString("DialogParticipantProperties")
					+ " - " + userObject.toString(), true);
		} else {
			xmlED.setTitle(ResourceManager
					.getLanguageDependentString("DialogParticipantProperties")
					+ " - " + userObject.toString());
			xmlED.editXMLElement(getPropertyObject().getPanel(), true, false);
		}

	}

	/**
	 * Gets a property object (DTDElement).
	 */
	public XMLElement getPropertyObject() {
		if (userObject instanceof XMLElement) {
			return (XMLElement) userObject;
		} else {
			return null;
		}

	}

	/**
	 * Gets a participant property which name is given in parameter what.
	 */
	public XMLElement get(String what) {
		if ((XMLComplexElement) getPropertyObject() != null) {
			return ((XMLComplexElement) getPropertyObject()).get(what);
		}
		return null;
	}

	/**
	 * Sets a participant property which name is given in parameter what to a
	 * value given in a parameter value.
	 */
	public void set(String what, Object value) {
		((XMLComplexElement) getPropertyObject()).set(what, value);
	}

	/**
	 * Gets a tooltip text for participant.
	 */
	public String getTooltip() {
		return ((com.ds.bpm.bpd.xml.elements.Participant) userObject)
				.getTooltip();
	}

	/**
	 * Gets an participant name property.
	 */
	public String toString() {
		return userObject.toString();
	}

	/**
	 * Create a clone of the user object.
	 * 
	 * @return Object a clone of this participant property object.
	 */
	protected Object cloneUserObject() {
		return null;
	}



}

/* End of Participant.java */
