/* BlockActivityRenderer.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：跳转活动图形描绘类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.graph;

import java.awt.Color;
import java.awt.Graphics;

import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.Utils;

/**
 * Class used to display block activity object.
 */
public class BlockActivityRenderer extends ActivityRenderer {

	private String resurceImage="Pointblockactivity";
	/**
	 * Paints block activity. Overrides super class paint to add specific
	 * painting.
	 */
	public void paint(Graphics g) {
	
		super.paint(g);
		// setting and drawing inner border and label text
		int xOff = (int) ((actW - innerW) / 2);
		int yOff = (int) ((actH - innerH) / 2);

		// drawing block activity lines
		g.setColor(bordercolor);
		g.drawLine(xOff, 0, xOff, actH - 1);
		g.drawLine(xOff + innerW - 1+10, 0, xOff + innerW - 1+10, actH - 1);
		//g.drawImage(image,xOff, yOff, innerW-53, innerH-22,imageObserver);
	}
	protected String getResurceImage(){
		return this.resurceImage;
	}
	protected Color getFillColor() {
		return Utils.getColor(BPDConfig.getInstance().getBlockActivityColor());
	}

}
