package com.ds.bpm.bpd.enums;

import com.ds.bpm.bpd.xml.elements.formula.FormulaEnumsValueParameter;
import com.ds.bpm.bpd.xml.elements.formula.FormulaParameter;
import com.ds.bpm.bpd.xml.elements.formula.database.FormulaFieldPanel;
import com.ds.bpm.bpd.xml.elements.formula.database.FormulaTablePanel;
import com.ds.bpm.bpd.xml.elements.formula.esd.FormulaApiPanel;
import com.ds.bpm.bpd.xml.elements.formula.esd.FormulaComponentPanel;
import com.ds.bpm.bpd.xml.elements.formula.esd.FormulaModulePanel;
import com.ds.bpm.bpd.xml.elements.formula.iot.*;
import com.ds.bpm.bpd.xml.elements.formula.org.*;
import com.ds.bpm.enums.formula.FormulaParamsDIC;
import com.ds.enums.Enums;
import com.ds.enums.attribute.AttributeName;
import com.ds.esb.config.formula.FormulaParams;

public enum FormulaEnums implements AttributeName {

    PERSON(FormulaParams.PERSON, FormulaPersonParameter.class),

    ORG(FormulaParams.ORG, FormulaOrgParameter.class),

    TABLE(FormulaParams.TABLE, FormulaTablePanel.class),

    FILED(FormulaParams.FILED, FormulaFieldPanel.class),


    ESDCOM(FormulaParams.ESDCOM, FormulaComponentPanel.class),

    API(FormulaParams.API, FormulaApiPanel.class),

    CLASSNAME(FormulaParams.CLASSNAME, FormulaModulePanel.class),

    PERSONROLE(FormulaParams.PERSONROLE, FormulaPersonRoleParameter.class),

    PERSONGROUP(FormulaParams.PERSONGROUP, FormulaPersonGroupParameter.class),
    PERSONDUTY(FormulaParams.PERSONDUTY, FormulaPersonDutyParameter.class),
    PERSONLEVEL(FormulaParams.PERSONLEVEL, FormulaPersonLevelParameter.class),

    SENSOR(FormulaParams.SENSOR, FormulaSensorParameter.class),

    IRVALUE(FormulaParams.IRValue, FormulaEnumsValueParameter.class),

    GATEWAY(FormulaParams.GATEWAY, FormulaGatewayParameter.class),

    AREA(FormulaParams.AREA, FormulaAreaParameter.class),

    PLACE(FormulaParams.PLACE, FormulaPlaceParameter.class),

    COMMAND(FormulaParams.COMMAND, FormulaDataKeyParameter.class),
    COMMANDEVENT(FormulaParams.COMMANDEVENT, FormulaDataKeyParameter.class),

    SERVICEEVENT(FormulaParams.COMMANDEVENT, FormulaDataKeyParameter.class),

    DEVICETYPE(FormulaParams.DEVICETYPE, FormulaDeviceTypeParameter.class),

    DEVICEDATAKEY(FormulaParams.DeviceDataTypeKey, FormulaDataKeyParameter.class),
    DEVICEEVENT(FormulaParams.DEVICEEVENT, FormulaDataKeyParameter.class);

    private String name;
    private Class<? extends FormulaParameter> clazz;
    private Class<? extends Enums> dicClazz;
    private String displayName;

    FormulaEnums(FormulaParams params, Class<? extends FormulaParameter> clazz) {

        this.name = params.getType();
        this.displayName = params.getName();
        this.clazz = clazz;
        this.dicClazz = FormulaParamsDIC.fromType(params.getType()).getDicClass();

    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<? extends FormulaParameter> getClazz() {
        return clazz;
    }

    public void setClazz(Class<? extends FormulaParameter> clazz) {
        this.clazz = clazz;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public static FormulaEnums fromName(String name) {
        for (FormulaEnums type : FormulaEnums.values()) {
            if (type.getName().equals(name)) {
                return type;
            }
        }
        return null;
    }

    @Override
    public String getType() {

        return name;
    }

}
