/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：全图预览的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.MissingResourceException;

import javax.swing.JDialog;
import javax.swing.JFrame;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDOverviewPanel;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ResourceManager;

/**
 * Action that shows overview of current graph.
 */
public class ShowOverview extends ActionBase {

	private JDialog overviewDlg;

	private BPDOverviewPanel overviewPanel;

	public ShowOverview(PackageEditor pe) {
		super(pe);
	}

	public void actionPerformed(ActionEvent e) {
		if (overviewDlg == null) {
			// Create a dialog containing an instance of
			// LibraryPanel.
			String title;
			try {
				title = ResourceManager
						.getLanguageDependentString("OverviewKey");
			} catch (MissingResourceException mre) {
				title = "Overview";
			}
			Window w = editor.getWindow();
			if (w instanceof JFrame) {
				overviewDlg = new JDialog((JFrame) w, title, false);
			} else {
				overviewDlg = new JDialog((JDialog) w, title, false);
			}
			Container fContentPane = overviewDlg.getContentPane();

			fContentPane.setLayout(new BorderLayout());
			overviewPanel = new BPDOverviewPanel(BPD.getInstance()
					.getActivedProcessEditor().getGraph());
			fContentPane.add(overviewPanel);
			overviewDlg.setSize(new Dimension(400, 320));
			overviewDlg.setLocationRelativeTo(w);
		}
		overviewDlg.show();
		overviewPanel.componentResized(null);
	}
}
