/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：保存所有打开工作流的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;

import javax.swing.JTabbedPane;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ProcessEditor;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;

/**
 * Class that realizes <B>save</B> action. 保存操作
 */
public class SaveAll extends Save {

	public SaveAll(PackageEditor editor) {
		super(editor, "SaveAll");
	}

	public void actionPerformed(ActionEvent e) {
		JTabbedPane ctp = ((PackageEditor) editor).getContentTabbedPane();
		Component[] processEditorArray = (Component[]) ctp.getComponents();
		ProcessEditor activedProcessEditor = BPD.getInstance()
				.getActivedProcessEditor();
		for (int i = 0; i < processEditorArray.length; i++) {
			ProcessEditor processEditor = ((ProcessEditor) processEditorArray[i]);
			BPD.getInstance().setActivedProcessEditor(processEditor);
			WorkflowProcess pe = (WorkflowProcess) BPD.getInstance()
			.getActivedProcessEditor().getGraph().getPropertyObject();
			if (!pe.isSubFlow()){
			super.actionPerformed(e);
			}
		}
		BPD.getInstance().setActivedProcessEditor(activedProcessEditor);
	
		// 设置工作流配置的按钮是否可用
		((PackageEditor) editor).valueChanged(null);
		// 将工作流图形设置为没有改变
		BPD.getInstance().setModified(false);
	}
}
