/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：移除路由转折点的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Map;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDMarqueeHandler;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.graph.Transition;
import com.ds.bpm.bpd.graph.TransitionView;

import org.jgraph.graph.CellView;

/**
 * Class that realizes <B>RemovePoint</B> action. "Breaking point" is removed
 * from transition at the popup position (if there is one near).
 */
public class RemovePoint extends ActionBase {

	public RemovePoint(PackageEditor pe) {
		super(pe);
	}

	public void actionPerformed(ActionEvent e) {
		BPDMarqueeHandler pemh = (BPDMarqueeHandler) BPD.getInstance()
				.getActivedProcessEditor().getGraph().getMarqueeHandler();
		Point removeAt = pemh.getPopupPoint();
		Object transition = BPD.getInstance().getActivedProcessEditor()
				.getGraph().getSelectionCell();
		if (transition instanceof Transition) {
			CellView view = BPD.getInstance().getActivedProcessEditor()
					.getGraph().getGraphLayoutCache().getMapping(transition,
							false);
			TransitionView tv = (TransitionView) view;
			tv.removePoint(removeAt);
			// updating xml object
			Transition tr = (Transition) transition;
			com.ds.bpm.bpd.xml.elements.Transition t = (com.ds.bpm.bpd.xml.elements.Transition) tr
					.getUserObject();
			int noOfPoints = tv.getPointCount();
			Map pnts = new Hashtable();
			for (int i = 1; i < noOfPoints - 1; i++) {
				pnts.put(new Integer(i), tv.getPoint(i));
			}
			t.setBreakPoints(pnts);
		}
	}
}
