/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：登录服务器的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;

import javax.swing.JFrame;

import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.server.panels.LoginDialog;

/**
 * Class that realizes <B>Login</B> action.
 */
public class Login extends ActionBase {

	/**
	 * 登陆远端服务器操作的构造方法
	 * 
	 * @param editor
	 *            主界面对象
	 */
	public Login(PackageEditor editor) {
		super(editor);
	}

	/**
	 * 操作的具体实现方法
	 * 
	 * @param e
	 *            操作事件
	 */
	public void actionPerformed(ActionEvent e) {
		// 显示登陆对话框
		Dimension dialogDimension = new Dimension(300, 200);
		JFrame frame = (JFrame) editor.getWindow();
		String title = ResourceManager
				.getLanguageDependentString("RemoteLogin.Name.display");
		final LoginDialog loginDlg = new LoginDialog(frame, title, true);
		loginDlg.setSize(dialogDimension);
		loginDlg.setLocationRelativeTo(frame);
		Utils.center(loginDlg, 100, 100);
		loginDlg.show();
	}

}
