/*
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import javax.swing.JFrame;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.panels.XMLPanel;


/**
 * Class that realizes <B>external packages</B> action.
 */
public class ExternalPackages extends ActionBase {

   public ExternalPackages (PackageEditor editor) {
      super(editor);
   }

   public void actionPerformed(ActionEvent e) {
      PackageEditor pe=(PackageEditor)editor;
    /*
	  if (!pe.isInitialized()) {
         pe.enterPackageID();
      }
      
      if (BPD.getInstance().getFilename()==null) {
         String msg=ResourceManager.getLanguageDependentString(
            "InformationFileNeedToBeSavedBeforeAddingExternalPackages");
         BPD.getInstance().message(msg,JOptionPane.INFORMATION_MESSAGE);
         return;
      }
      */
      XMLPanel p=pe.getXMLPackage().getPanel(4);

      XMLElementDialog d=new XMLElementDialog((JFrame)pe.getWindow(),
         ResourceManager.getLanguageDependentString("PackageKey")+" '"+
         pe.getXMLPackage().get("Id").toString()+"' - "+
         ResourceManager.getLanguageDependentString("ExternalPackagesKey"));
      Set pre=new HashSet(BPD.getInstance().getXMLInterface().getAllPackageIds());
      d.editXMLElement(p,false,false);
      Set post=new HashSet(BPD.getInstance().getXMLInterface().getAllPackageIds());
      // CREATES GRAPHS FOR NEWLY INSERTED EXTERNAL PACKAGES
      post.removeAll(pre);
      Iterator it=post.iterator();
      while (it.hasNext()) {
       //  pe.createGraphForPackage(BPD.getInstance().getXMLInterface().getPackageById((String)it.next()),true);
      }
   }
}
