/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：关闭所有打开的工作流
 * Authors： wenzhang li
 * Company： 基督山BPM
 *  CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ProcessEditor;
import com.ds.bpm.bpd.graph.BlockActivityEditor;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;

/**
 * Class that realizes <B>CloseAll</B> action. Close all of opened processes.
 */
public class CloseAll extends Close {

    public CloseAll(PackageEditor pe) {
        super(pe);
    }

    public void actionPerformed(ActionEvent e) {
        JTabbedPane ctp = ((PackageEditor) editor).getContentTabbedPane();
        Component[] processEditorArray = (Component[]) ctp.getComponents();
        if (processEditorArray.length == 0) {
            //   System.exit(0);
            BPD.getInstance().getMainFrame().hide();
        } else {
            for (int i = 0; i < processEditorArray.length; i++) {
                if (!(processEditorArray[i] instanceof BlockActivityEditor)) {
                    ProcessEditor processEditor = ((ProcessEditor) processEditorArray[i]);
                    BPD.getInstance().setActivedProcessEditor(processEditor);

                    WorkflowProcess pe = (WorkflowProcess) BPD.getInstance()
                            .getActivedProcessEditor().getGraph().getPropertyObject();
                    if (!pe.isSubFlow()) {
                        super.actionPerformed(e);
                    }

                }
            }
            BPD.getInstance().getMainFrame().hide();
        }
    }

}
