/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：关闭当前正在编辑的工作流
 * Authors： wenzhang li
 * Company： 基督山BPM
 *  CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;

import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDConstants;
import com.ds.bpm.bpd.MainCenterDownPanel;
import com.ds.bpm.bpd.MainLeftDownPanel;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ProcessEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.graph.BlockActivityGraph;
import com.ds.bpm.bpd.xml.elements.Package;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;

/**
 * Class that realizes <B>Close</B> action. Close the process of editing.
 */
public class Close extends ActionBase {

	public Close(PackageEditor pe) {
		super(pe);
	}

	public void actionPerformed(ActionEvent e) {
		WorkflowProcess pe = (WorkflowProcess) BPD.getInstance()
				.getActivedProcessEditor().getGraph().getPropertyObject();
		Package pkg = pe.getPackage();

		JTabbedPane ctp = ((PackageEditor) editor).getContentTabbedPane();
		Component[] processEditorArray = (Component[]) ctp.getComponents();

		if ((e == null) || (!pe.isSubFlow())
				&& (!(e.getSource() instanceof BlockActivityGraph))) {

			/*
			 * add by wenzhang 06-02-28 判断包中的其他流程（子流程）是否发生改变 如果改变则将主流程的状态设为TRUE
			 */
			/** **************************************************************** */

			for (int i = 0; i < processEditorArray.length; i++) {
				ProcessEditor processEditor = ((ProcessEditor) processEditorArray[i]);
				Package allpkg = ((WorkflowProcess) processEditor.getGraph()
						.getPropertyObject()).getPackage();
				if (processEditor.getProcessModified() && allpkg.equals(pkg)) {
					BPD.getInstance().getActivedProcessEditor()
							.setProcessModified(true);
					continue;
				}
			}

			/** ************************************************************ */

			if (BPD.getInstance().getActivedProcessEditor()
					.getProcessModified()) {
				int flag = JOptionPane
						.showConfirmDialog(
								editor.getWindow(),
								ResourceManager
										.getLanguageDependentString("SaveChangesDialog"),
								BPD.getAppTitle(), JOptionPane.YES_NO_OPTION);
				// 取得当前正在编辑的工作流对象
				if (flag == JOptionPane.YES_OPTION) {
					editor.getAction("Save").actionPerformed(null);
				}
			}
			/*
			 * add by wenzhang 06-02-28 如果关闭的是主流程窗体则将其（已打开的）子流程关闭
			 */
			/** ************************************************************* */
			for (int i = 0; i < processEditorArray.length; i++) {
				ProcessEditor processEditor = ((ProcessEditor) processEditorArray[i]);
				Package allpkg = ((WorkflowProcess) processEditor.getGraph()
						.getPropertyObject()).getPackage();
				if (allpkg.equals(pkg)) {
					BPD.getInstance().setActivedProcessEditor(processEditor);
					delplan();
				}
			}
			/** ************************************************************* */
		} else {
			delplan();
		}

	}

	public void delplan() {
		if (BPD.getInstance().getActivedProcessEditor() == null) {

			return;
		}
		if (BPD.getInstance().getActivedProcessEditor().getProcessFlag() != null

				&& BPD.getInstance().getActivedProcessEditor().getGraph()
						.getXPDLObject() instanceof WorkflowProcess) {
			Package pkg = BPD.getInstance()
					.getActivedProcessEditor().getGraph().getXMLPackage();
			Save.updateExtendedAttributesForWorkflowProcesses(pkg);
			// 注销打开的本地包
			String processFlag = BPD.getInstance().getActivedProcessEditor()
					.getProcessFlag();

			String processDefVersionId = ((WorkflowProcess) BPD.getInstance()
					.getActivedProcessEditor().getGraph().getXPDLObject())
					.getVersionID();

			if (processFlag.equals(BPDConstants.PROCESS_LOCAL)) {
				String pkgId = BPD.getInstance().getActivedProcessEditor()
						.getGraph().getXMLPackage().get("Id").toString();

				BPD.getInstance().getXMLInterface().closePackage(pkgId);

				// 将关闭流程从本地正在编辑的流程集合中移除
				// BPD.getInstance().getLocalEditingProcessMap().remove(processDefVersionId);

				// 将关闭流程从正在编辑的流程集合中移除
				processDefVersionId = ((WorkflowProcess) BPD.getInstance()
						.getActivedProcessEditor().getGraph().getXPDLObject())
						.getVersionID();
				BPD.getInstance().getLocalEditingProcessMap().remove(pkgId);

				// 从本地打开流程集合中，移除当前关闭流程
				// Map localProcessMap = BPD.getInstance().getLocalProcessMap();
				// processDefVersionId =
				// ((WorkflowProcess)BPD.getInstance().getActivedProcessEditor().getGraph().getXPDLObject()).getVersionID();
				// if(localProcessMap.containsKey(processDefVersionId)){
				// localProcessMap.remove(processDefVersionId);
				// }
			} else if (processFlag.equals(BPDConstants.PROCESS_REMOTE)) {

				// 将关闭流程从远程正在编辑的流程集合中移除
				BPD.getInstance().getRemoteEditingProcessMap().remove(
						processDefVersionId);
				BPD.getInstance().getRomveWorkflowProcessMap().remove(
						processDefVersionId);
				/*
				 * //将关闭流程从正在编辑的流程集合中移除 processDefVersionId =
				 * ((WorkflowProcess)BPD.getInstance().getActivedProcessEditor().getGraph().getXPDLObject()).getVersionID();
				 * Set editingProcessSet =
				 * BPD.getInstance().getEditingProcessMap().entrySet(); Iterator
				 * editingProcessIter = editingProcessSet.iterator();
				 * while(editingProcessIter.hasNext()){ Entry
				 * editingProcessEntry = (Entry)editingProcessIter.next();
				 * if(editingProcessEntry.getValue().equals(processDefVersionId)){
				 * BPD.getInstance().getEditingProcessMap().remove(editingProcessEntry.getKey());
				 * break; } } //从远端打开流程集合中，移除当前关闭流程 Map remoteProcessMap =
				 * BPD.getInstance().getRemoteProcessMap(); processDefVersionId =
				 * ((WorkflowProcess)BPD.getInstance().getActivedProcessEditor().getGraph().getXPDLObject()).getVersionID();
				 * if(remoteProcessMap.containsKey(processDefVersionId)){
				 * remoteProcessMap.remove(processDefVersionId); }
				 */
			}

			editor.getContentTabbedPane().remove(
					BPD.getInstance().getActivedProcessEditor());
			// 如果没有打开的工作流，那么工作流图形按钮都设置为不可用
			if (editor.getContentTabbedPane().getTabCount() == 0) {
				editor.getBarFactory().activateSpecialButtonGroup(false);
				BPD.getInstance().setModified(false);
				BPD.getInstance().setActivedProcessEditor(null);
				((PackageEditor) editor).clearProcessObjectMap();
				// editor.graphMainsplitPane.remove(editor.errPanel);
				// BPD.getInstance().getPackageEditor().setXMLPackage(null);
				BPD.getInstance().getPackageEditor().getStatusBar()
						.updateMessage();

				editor.resetUndoManager();
			} else {

				BPD.getInstance().setActivedProcessEditor(
						(ProcessEditor) editor.getContentTabbedPane()
								.getSelectedComponent());

			}

			// 刷新流程列表
			if (processFlag.equals(BPDConstants.PROCESS_LOCAL)) {
				MainLeftDownPanel.getInstance(editor).getPackageTreePanel()
						.refreshPackageTreePanel();
				if (editor instanceof PackageEditor) {
					PackageEditor packageEdit = (PackageEditor) editor;

					Map overViewMap = MainLeftDownPanel.getInstance(editor)
							.getLocalOverViewMap();
					MainLeftDownPanel.getInstance(editor).tabOverviewPanel
							.remove((Component) overViewMap
									.get(processDefVersionId));
					overViewMap.remove(processDefVersionId);
					if (BPD.getInstance().getActivedProcessEditor() != null
							&& !(BPD.getInstance().getActivedProcessEditor()
									.getGraph() instanceof BlockActivityGraph)) {
						MainLeftDownPanel.getInstance(editor).refreshOverview();
					}
				}
			}
			if (processFlag.equals(BPDConstants.PROCESS_REMOTE)) {
				MainLeftDownPanel.getInstance(editor)
						.getRemotePackageTreePanel().refreshPackageTreePanel();
				if (editor instanceof PackageEditor) {
					PackageEditor packageEdit = (PackageEditor) editor;

					Map overViewMap = MainLeftDownPanel.getInstance(editor)
							.getLocalOverViewMap();

					MainLeftDownPanel.getInstance(editor).tabOverviewPanel
							.remove((Component) overViewMap
									.get(processDefVersionId));
					overViewMap.remove(processDefVersionId);
					if (BPD.getInstance().getActivedProcessEditor() != null
							&& !(BPD.getInstance().getActivedProcessEditor()
									.getGraph() instanceof BlockActivityGraph)) {
						MainLeftDownPanel.getInstance(editor).refreshOverview();

					}
				}
			}

			// 设置工作流配置的按钮是否可用

			((PackageEditor) editor).valueChanged(null);
			// BPD.getInstance().setPackageEditor(null);
			// MainCenterDownPanel.getInstance(null).refreshView();
			try {
				((MainCenterDownPanel) editor.graphMainsplitPane
						.getBottomComponent()).refreshView();
			} catch (Exception e) {

			}
			// MainCenterDownPanel.getInstance(null).repaint();

		} else {
			editor.getContentTabbedPane().remove(
					BPD.getInstance().getActivedProcessEditor());
			MainCenterDownPanel mcdp = MainCenterDownPanel.getInstance(editor);
			mcdp.refreshView();
		}
	}
}
