/* Utils.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：通用工具类
 * Authors： wenzhang li
 * Company： 基督山BPM
 *  CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.graph.Activity;
import com.ds.bpm.bpd.graph.End;
import com.ds.bpm.bpd.graph.NoRouting;
import com.ds.bpm.bpd.graph.Start;
import com.ds.bpm.bpd.graph.Transition;
import com.ds.bpm.bpd.misc.PFLocale;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.common.util.XMLUtility;

public class Utils {

	/**
	 * Take the given string and chop it up into a series of strings on given
	 * boundries. This is useful for trying to get an array of strings out of
	 * the resource file.
	 */
	public static String[] tokenize(String input, String boundary) {
		if (input.indexOf("/")>-1){
			boundary="/";
		}
		Vector v = new Vector();
		if (input == null || input.trim().equals("") || boundary == null) {
			return (String[]) v.toArray(new String[0]);
		}
		if (boundary.equals("")) {
			return new String[] { input };
		}
		input = input.trim();
		while (input.indexOf(boundary) != -1) {
			v.addElement(input.substring(0, input.indexOf(boundary)));
			input = input
					.substring(input.indexOf(boundary) + boundary.length());
		}
		v.addElement(input);
		return (String[]) v.toArray(new String[v.size()]);
	}

	/** Returns the class name without package. */
	public static String getUnqualifiedClassName(Class cls) {
		String name = cls.getName();
		int lastDot = name.lastIndexOf(".");
		if (lastDot >= 0) {
			name = name.substring(lastDot + 1, name.length());
		}
		return name;
	}

	/**
	 * Returns the set of description for Start elements of given editor's
	 * graph. This description is written to the xml file. The description for a
	 * Start graph object contains of participant ID where start is placed in,
	 * the ID of activity that start points to, the relative position within
	 * participant, and indicator if transition from start object isself-routed
	 * or not.
	 * 
	 * @param pe
	 *            The editor.
	 * @return The set of descriptions of Start objects of given editor's graph.
	 */
	public static Set getStartDescriptions(ProcessEditor pe) {
		Set startDescriptions = new HashSet();

		if (pe != null) {
			WorkflowManager workflowManager = pe.getGraph()
					.getWorkflowManager();
			Set starts = workflowManager.getStarts();
			// ******* start
			if (starts.size() > 0) {
				Iterator it = starts.iterator();
				while (it.hasNext()) {
					Start start = (Start) it.next();
					Set outTransitions = start.getOutgoingTransitions();
					// ** participant ID
					String startDescription = workflowManager
							.getParticipantID(start)
							+ ";";
					// ** first activity ID
					String ID = "-1";
					Transition t = null;
					if (outTransitions.size() > 0) {
						t = (Transition) outTransitions.toArray()[0];
						if (t != null) {
							ID = t.getTargetActivity().get("Id").toString();
						}
					}
					startDescription += (ID + ";");
					// ** position
					if (pe.getGraph().getGraphLayoutCache().getMapping(start, false)!=null){
					Point pOffset = workflowManager.getOffset(start);
					startDescription += (String.valueOf(pOffset.x) + ";");
					startDescription += (String.valueOf(pOffset.y) + ";");
					}
					if (t != null) {
						boolean isRouted = Utils.isRoutingTransition(t
								.getAttributes());
						startDescription += (((isRouted) ? (com.ds.bpm.bpd.xml.elements.Transition.SIMPLE_ROUTING)
								: (com.ds.bpm.bpd.xml.elements.Transition.NO_ROUTING)));
					}
					startDescriptions.add(startDescription);
				}
			}
		}
		return startDescriptions;
	}

	/**
	 * Returns the set of descriptions for End elements of given editor's graph.
	 * This descriptions are written to the xml file. The description for an End
	 * graph object contains of participant ID where end is placed in, the ID of
	 * activity that points to end, the relative position within participant,
	 * and indicator if transition toward end is self-routed or not.
	 * 
	 * @param pe
	 *            The editor.
	 * @return The set of descriptions for End objects of given editor's graph.
	 */
	public static Set getEndDescriptions(ProcessEditor pe) {
		Set endDescriptions = new HashSet();

		if (pe != null) {
			WorkflowManager workflowManager = pe.getGraph()
					.getWorkflowManager();
			Set ends = workflowManager.getEnds();
			if (ends.size() > 0) {
				Iterator it = ends.iterator();
				while (it.hasNext()) {
					End end = (End) it.next();
					// ** participant ID
					String endDescription = workflowManager
							.getParticipantID(end)
							+ ";";
					// ** last activity ID
					Set inTransitions = end.getIncomingTransitions();
					String ID = "";
					Transition t = null;
					if (inTransitions.size() > 0) {
						for (Iterator iter = inTransitions.iterator(); iter
								.hasNext();) {
							t = (Transition) iter.next();
							if (t != null) {
								ID = ID
										+ WorkflowProcess.ENDOFWORKFLOWACT_SEPARATE
										+ t.getSourceActivity().get("Id")
												.toString();
							}
						}
						if (ID.equals("")) {
							ID = "-1";
						} else {
							ID = ID.substring(1);
						}
					}
					endDescription += (ID + ";");
					// ** position
					if (pe.getGraph().getGraphLayoutCache().getMapping(end, false)!=null){
						Point pOffset = workflowManager.getOffset(end);
						endDescription += (String.valueOf(pOffset.x) + ";");
						endDescription += (String.valueOf(pOffset.y) + ";");
						if (t != null) {
							boolean isRouted = Utils.isRoutingTransition(t
									.getAttributes());
							endDescription += (((isRouted) ? (com.ds.bpm.bpd.xml.elements.Transition.SIMPLE_ROUTING)
									: (com.ds.bpm.bpd.xml.elements.Transition.NO_ROUTING)));
						}
						endDescriptions.add(endDescription);
					}
					
				}
			}
		}
		return endDescriptions;
	}
	 public static boolean hasConnectedEndBubble (Activity act) {
	      Set trans=act.getNonExceptionalOutgoingTransitions();
	      if (trans.size()==1 || trans.size()==2) {
	         Object[] trnsArr=trans.toArray();
	         if((((Transition)trnsArr[0]).getTargetActivity() instanceof End) ||
	               (trans.size()==2 && ((Transition)trnsArr[1]).getTargetActivity() instanceof End)) {
	            return true;
	         }
	      }
	      return false;
	   }
	 public static boolean hasCircularTransitions (Set transitions) {
	      Iterator it=transitions.iterator();
	      while (it.hasNext()) {
	         Transition t=(Transition)it.next();
	         Object source = ((DefaultPort)(t.getSource())).getParent();
	         Object target = ((DefaultPort)(t.getTarget())).getParent();
	         if (source.equals(target)) return true;
	      }
	      return false;
	   }
	/* 
	 public static void removeBubblesExtAttribs (Package pkg) {
	      WorkflowProcesses wprocs=(WorkflowProcesses)pkg.get("WorkflowProcesses");
	      Iterator wps=wprocs.toCollection().iterator();
	      while (wps.hasNext()) {
	         WorkflowProcess wp=(WorkflowProcess)wps.next();
	         wp.getEndDescriptions().clear();
	         wp.getStartDescriptions().clear();
	         Activities activities=(Activities)wp.get("Activities");
	         Iterator acts=activities.toCollection().iterator();
	         while (acts.hasNext()) {
	            com.ds.bpm.bpd.xml.elements.Activity act=
	               (com.ds.bpm.bpd.xml.elements.Activity)acts.next();
	            act.getEndDescriptions().clear();
	            act.getStartDescriptions().clear();
	         }
	         ActivitySets asets=(ActivitySets)wp.get("ActivitySets");
	         Iterator ass=asets.toCollection().iterator();
	         while (ass.hasNext()) {
	            ActivitySet as=(ActivitySet)ass.next();
	            activities=(Activities)wp.get("Activities");
	            acts=activities.toCollection().iterator();
	            while (acts.hasNext()) {
					com.ds.bpm.bpd.xml.elements.Activity act=
	                  (com.ds.bpm.bpd.xml.elements.Activity)acts.next();
	               act.getEndDescriptions().clear();
	               act.getStartDescriptions().clear();
	            }

	         }
	      }
	    }
*/
	 
	 // Useful only if JaWE is set to work without start/end bubbles
	   public static boolean isStartingActivity (Activity act) {
	      Set trans=act.getIncomingTransitions();
	      if (trans.size()==0 || (trans.size()==1 && Utils.hasCircularTransitions(trans))) {
	         return true;
	      }
	      return false;
	   }

	   // Useful only if JaWE is set to work without start/end bubbles
	   public static boolean isEndingActivity (Activity act) {
	      Set trans=act.getNonExceptionalOutgoingTransitions();
	      if (trans.size()==0 || (trans.size()==1 && Utils.hasCircularTransitions(trans))) {
	         return true;
	      }
	      return false;
	   }
	/**
	 * Returns the color parsed from the given string. The color can be given in
	 * three different string form:
	 * <ul>
	 * <li> using prefix Color, dot and wanted color, e.g. <b>Color.red</b>
	 * <li> using prefix SystemColor, dot and wanted color, e.g.
	 * <b>SystemColor.desktop</b>
	 * <li> using RGB like string, e.g. <b>R=124,G=213,B=12</b>
	 * </ul>
	 * 
	 * @param col
	 *            The string representation of wanted color.
	 * @return The color based on given string or null if incorrect
	 */
	public static Color getColor(String col) {
		Color c = null;
		int dotInd = col.indexOf(".");
		int r, g, b;
		if (col.indexOf("Color") != -1 && dotInd != -1) {
			try {
				ClassLoader cl = BPDConfig.class.getClassLoader();
				Class cls = cl
						.loadClass("java.awt." + col.substring(0, dotInd));
				Field f = cls.getField(col.substring(dotInd + 1));
				c = (Color) f.get(null);
			} catch (Exception ex) {
			}
		} else {
			try {
				int i1 = col.indexOf("R=");
				if (i1 == -1)
					i1 = col.indexOf("r=");
				int i1c = col.indexOf(",", i1 + 2);
				int i2 = col.indexOf("G=");
				if (i2 == -1)
					i2 = col.indexOf("g=");
				int i2c = col.indexOf(",", i2 + 2);
				int i3 = col.indexOf("B=");
				if (i3 == -1)
					i3 = col.indexOf("b=");
				if (i1 != -1 && i1c != -1 && i2 != -1 && i2c != -1 && i3 != -1
						&& (i1c < i2) && (i2c < i3)) {
					r = Integer.valueOf(col.substring(i1 + 2, i1c).trim())
							.intValue();
					if (r < 0)
						r = 0;
					if (r > 255)
						r = 255;
					g = Integer.valueOf(col.substring(i2 + 2, i2c).trim())
							.intValue();
					if (g < 0)
						g = 0;
					if (g > 255)
						g = 255;
					b = Integer.valueOf(col.substring(i3 + 2).trim())
							.intValue();
					if (b < 0)
						b = 0;
					if (b > 255)
						b = 255;
					c = new Color(r, g, b);
				}
			} catch (Exception ex) {
			}
		}
		return c;
	}

	/**
	 * Returns the set of (XML) activities that have split or join.
	 * 
	 * @param acts
	 *            The activities graph objects that are checked if their XML
	 *            object have split or join, depending on the second parameter.
	 * @param sOrJ
	 *            if 0, activity is checked for split, otherwise it is checked
	 *            for join
	 */
	public static Set getSplitOrJoinActivities(Set acts, int sOrJ) {
		Set sOrJactivities = new HashSet();
		if (acts == null)
			return sOrJactivities;
		Iterator it = acts.iterator();
		while (it.hasNext()) {
			Activity act = (Activity) it.next();
			if (!(act instanceof Start) && !(act instanceof End)) {
				Iterator iter;
				if (sOrJ == 0) {
					iter = act.getOutgoingTransitions().iterator();
				} else {
					iter = act.getIncomingTransitions().iterator();
				}
				int noOfTrans = 0;
				while (iter.hasNext()) {
					Transition tr = (Transition) iter.next();
					com.ds.bpm.bpd.xml.elements.Transition t = (com.ds.bpm.bpd.xml.elements.Transition) tr
							.getUserObject();
					if (t != null && t.getFrom() != null && t.getTo() != null) {
						noOfTrans++;
					}
				}
				if (noOfTrans > 1) {
					sOrJactivities.add(act);
				}
			}
		}

		return sOrJactivities;
	}

	// ******************************** DEBUGGING STUFF
	// ****************************
	/** Used for debug only */
	public static void printStrings(String[] s) {
		if (s != null) {
			for (int i = 0; i < s.length; i++) {
				System.out.println("String no " + i + " = " + s[i]);
			}
		} else {
			System.out.println("Passed string array is null !!!");
		}
	}

	// **************************** END OF DEBUGGING STUFF
	// *************************

	/**
	 * 判断是否是自适应路由
	 * 
	 * @param attributes
	 * @return true or false
	 */
	public static boolean isRoutingTransition(Map attributes) {
		Object routing = GraphConstants.getRouting(attributes);
		if (routing != null && !(routing instanceof NoRouting)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * 设置窗口位于屏幕的中心位置
	 * 
	 * @param w
	 * @param minXDiffFromMax
	 * @param minYDiffFromMax
	 */
	public static void center(Window w, int minXDiffFromMax, int minYDiffFromMax) {
		w.pack();

		// make dialog smaller if needed, and center it
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension windowSize = w.getPreferredSize();
		if (windowSize.width > screenSize.width - minXDiffFromMax) {
			windowSize.width = screenSize.width - minXDiffFromMax;
		}
		if (windowSize.height > screenSize.height - minYDiffFromMax) {
			windowSize.height = screenSize.height - minYDiffFromMax;
		}
		w.setSize(windowSize);
		w.setLocation(screenSize.width / 2 - (windowSize.width / 2),
				screenSize.height / 2 - (windowSize.height / 2));
	}

	/**
	 * 获得属性文件列表
	 * 
	 * @return the List Of PropertyFiles
	 */
	public static List findPropertyFiles() {
		List pfs = new ArrayList();

		URL u = Utils.class.getClassLoader().getResource(
				BPDConstants.RESOURCE_FILEPATH);
		File path = null;
		if (u != null) {
			path = new File(u.getFile());
		}
		// if folder exists and realy is a folder but not file
		if (path != null && path.exists() && path.isDirectory()) {
			// getting all .property files within folder
			pfs.addAll(Arrays.asList(path.list(new PFFilter())));
		} else {
			JarFile jfile = null;
			try {
				String jp = BPDConstants.RESOURCE_FILEPATH + "BPD.properties";
				u = Utils.class.getClassLoader().getResource(jp);
				String jarPath = u.getFile().substring(0,
						u.getFile().length() - jp.length() - 2);
				jarPath = jarPath.substring(5);
				jfile = new JarFile(jarPath, false);
				// get all entries
				Enumeration e = jfile.entries();
				// loop through entries and find appropriate ones
				while (e.hasMoreElements()) {
					try {
						ZipEntry entry = (ZipEntry) e.nextElement();
						String entryname = entry.getName();
						// entry must end with '.properties'
						if (entryname.indexOf(BPDConstants.APPLICATION_NAME) != -1
								&& entryname.endsWith(".properties")) {
							pfs.add(entryname);
						}
					} catch (Exception ex) {
					}
				}
			} catch (Exception ex) {
			}
		}

		// if there are no property files, try to find the default ones
		// distributed
		// with BPD
		if (pfs.size() == 0) {
			u = Utils.class.getClassLoader().getResource(
					BPDConstants.RESOURCE_FILEPATH + "BPD.properties");
			if (u != null) {
				pfs.add("BPD.properties");
			}
			u = Utils.class.getClassLoader().getResource(
					BPDConstants.RESOURCE_FILEPATH + "BPD_en.properties");
			if (u != null) {
				pfs.add("BPD_en.properties");
			}
		}
		List pfLocales = new ArrayList();
		if (pfs.size() > 0) {
			// adding default locale (for default property file)
			pfLocales.add(new PFLocale());
			for (int i = 0; i < pfs.size(); i++) {
				String propFile = (String) pfs.get(i);
				int p1 = propFile.indexOf(BPDConstants.APPLICATION_NAME)
						+ BPDConstants.APPLICATION_NAME.length();
				boolean isDefault = !propFile.substring(p1, p1 + 1).equals("_");
				if (!isDefault) {
					PFLocale pfl = PFLocale
							.createPFLocale(propFile.substring(p1 + 1, propFile
									.length()
									- ".properties".length()));
					if (pfl != null) {
						pfLocales.add(pfl);
					}
				}
			}
		}
		return pfLocales;
	}

	/**
	 * 生成UUID
	 * 
	 * @return
	 */
	public static String generateUUID() {
		String uuid = UUID.randomUUID().toString();
		return uuid;
	}

	/**
	 * 验证输入字符串是否为数字
	 * 
	 * @param sValue
	 * @return
	 */
	public static boolean isNumber(String sValue) {
		boolean Ret = true;
		String NumStr = "0123456789";
		boolean decUsed = false;
		String chr;

		if (sValue == null) {
			return false;
		}

		if (sValue.length() < 1) {
			return true;
		}

		if (sValue.equals(".")) {
			Ret = false;
		}

		for (int i = 0; i < sValue.length(); i++) {
			chr = String.valueOf(sValue.charAt(i));
			if (NumStr.indexOf(chr) == -1) {
				if ((!decUsed) && chr.equals(".")) {
					decUsed = true;
				} else {
					Ret = false;
				}
			}
		}
		return Ret;
	}

	/**
	 * 验证输入字符串是否为int
	 * 
	 * @param sValue
	 * @return
	 */
	public static boolean isInt(String sValue) {
		boolean Ret = true;
		String NumStr = "0123456789";
		String chr;
		if (sValue == null) {
			return false;
		}
		if (sValue.trim().equals("")) {
			return true;
		}
		for (int i = 0; i < sValue.length(); ++i) {
			chr = String.valueOf(sValue.charAt(i));
			if (NumStr.indexOf(chr, 0) == -1) {
				Ret = false;
				break;
			}
		}
		Ret = Ret && (Integer.parseInt(sValue) < 2147483647);
		return Ret;
	}

	/**
	 * 判断指定名称得扩展属性是否存在
	 * 
	 * @param parent
	 *            扩展属性节点
	 * @param name
	 *            指定扩展属性的名称
	 * @return 存在返回true，否则返回false
	 */
	public static boolean isExtendedAttributeExisted(Node parent, String name) {
		boolean isExisted = false;
		List exAttrs = XMLUtility.getChildNodes(parent, Node.ELEMENT_NODE);
		for (int i = 0; i < exAttrs.size(); i++) {
			Element e = (Element) exAttrs.get(i);
			if (e.getAttribute("Name").equals(name)) {
				isExisted = true;
				break;
			}
		}
		return isExisted;
	}

	// 把Null值转换成""
	public static String filterNull(String val) {
		return (val == null) ? "" : val;
	}

	public static void toChildXML(Node parent,String key,String typeName,String value){
		if (key.lastIndexOf(".")!=-1){
			String newkey=key.substring(0,key.lastIndexOf("."));
			toChildXML(parent,newkey,typeName,value);
		}

		if (!value.equals("") && !Utils.isExtendedAttributeExisted(parent,key)){
			Element elemtm = parent.getOwnerDocument().createElement(
			"ExtendedAttribute");		
			elemtm.setAttribute("Name", key);
			elemtm.setAttribute("Type", typeName);
			elemtm.setAttribute("Value", value);
			parent.appendChild(elemtm);
		}
	}
	
	// 判断一个字符串是否存在于一字符串数组中
	public static boolean isExistedInArray(String[] array, String src) {
		boolean isExisted = false;
		if (array == null || array.length == 0 || src == null || src.equals("")) {
			return isExisted;
		}
		for (int i = 0; i < array.length; i++) {
			String tmp = array[i];
			if (tmp.trim().equals(src.trim())) {
				isExisted = true;
				break;
			}
		}
		return isExisted;
	}

	// 判断一个对象是否存在于一对象数组中
	public static boolean isExistedInArray(Object[] array, Object src) {
		boolean isExisted = false;
		if (array == null || array.length == 0 || src == null) {
			return isExisted;
		}
		for (int i = 0; i < array.length; i++) {
			Object tmp = array[i];
			if (tmp.equals(src)) {
				isExisted = true;
				break;
			}
		}
		return isExisted;
	}

	// 取得一个字符串存在与一字符串数组中的位置，不存在返回-1
	public static int getIndexofArray(String[] array, String src) {
		int index = -1;
		if (array == null || array.length == 0 || src == null || src.equals("")) {
			return index;
		}
		for (int i = 0; i < array.length; i++) {
			String tmp = array[i];
			if (tmp.trim().equals(src.trim())) {
				index = i;
				break;
			}
		}
		return index;
	}
}




class PFFilter implements FilenameFilter {
	String pfStr = ".properties";

	public boolean accept(File dir, String name) {
		String f = new File(name).getName();
		int fi = f.indexOf(BPDConstants.APPLICATION_NAME);
		int li = f.lastIndexOf(BPDConstants.APPLICATION_NAME);
		return (fi != -1 && fi == 0 && fi == li && f.endsWith(pfStr));
	}
}
