/* PEPortView.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：JGraph图形PortView扩展类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd;

import java.awt.Color;

import javax.swing.UIManager;

import org.jgraph.JGraph;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.PortRenderer;
import org.jgraph.graph.PortView;

/**
 * Extends PortView in such a way to implement method for setting sizes of all
 * ports, which is needed to enlarge their sizes to easily connect transitions.
 */

public class BPDPortView extends PortView {
	 protected static MyPortRenderer renderer;
	/**
	 * Creates object.
	 */
	public BPDPortView(Object cell, JGraph graph, CellMapper mapper) {
		super(cell, graph, mapper);
	}

	
	/**
	 * Sets size of all ports to given value.
	 */
	public static void setPortSize(int s) {
		if (size < 2)
			size = 2;
		size = s;
	}

	/**
	 * Returns port's size.
	 */
	public static int getPortSize() {
		return size;
	}
	 public CellViewRenderer getRenderer() {
	      if (renderer==null) {
	         renderer = new MyPortRenderer();
	      }
	      return renderer;
	   }
	 public static class MyPortRenderer extends PortRenderer {

	      public MyPortRenderer() {
	         Color fg=UIManager.getColor("MenuItem.selectionBackground");
	         Color bg=Utils.getColor(BPDConfig.getInstance().getHandleColor());
	         setForeground(fg);
	         setBackground(bg);
	      }
	   }
}

/* End of PEPortView.java */
