/* PEGraphUI.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：JGraph图形BasicGraphUI扩展类，图形界面类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;

import org.jgraph.JGraph;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphTransferable;
import org.jgraph.graph.ParentMap;
import org.jgraph.plaf.basic.BasicGraphUI;

import com.ds.bpm.bpd.graph.Activity;
import com.ds.bpm.bpd.graph.End;
import com.ds.bpm.bpd.graph.Participant;
import com.ds.bpm.bpd.graph.ParticipantView;
import com.ds.bpm.bpd.graph.Start;
import com.ds.bpm.bpd.graph.Transition;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;

/**
 * This class and it's inner classes controls mouse actions and clipboard. It is
 * adapted to get wanted editing cell behaviour, selection behaviour , to
 * implement cell overlaping, to implement right participant adjustment after
 * cell (or group of cells) is moved, and to implement proper copying and
 * pasting/cloning of cells, as well as pasting at wanted location (along with
 * right participant adjustment).
 */
public class BPDGraphUI extends BasicGraphUI {

	/** Variable that correct selection on mouse release. */
	protected boolean canMouseReleaseSelectCell = true;

	/**
	 * Point that represents paste location. It is set from editor when PasteAt
	 * action was triggered by popup menubar.
	 */
	protected Point insertionPoint = null;

	/**
	 * Returns graph.
	 */
	public AbstractGraph getGraph() {
		return (AbstractGraph) graph;
	}

	/**
	 * Sets location for pasting cells.
	 */
	public void setInsertionPoint(Point p) {
		insertionPoint = p;
	}
	 // FIXED by xxp - there was a problem when zooming-out activity
	   public void startEditingAtCell(JGraph graph,Object cell) {
	      if(cell!=null) startEditing(cell,null);
	   }

	/**
	 * Paint the background of this graph. Calls paintGrid.
	 */
	protected void paintBackground(Graphics g) {
		Rectangle pageBounds = new Rectangle(0, 0, graph.getWidth(), graph
				.getHeight());
		graph.setBackground(Utils.getColor(BPDConfig.getInstance()
				.getGraphBackgroundColor()));
		//麻点背景
		//if (graph.isGridVisible()) {
		//	paintGrid(graph.getGridSize(),g,pageBounds);
		//}
	}

	/**
	 * This method is called by EditAction class, as well as by pressing F2 or
	 * clicking a mouse on a cell.
	 */
	protected boolean startEditing(Object cell, MouseEvent event) {
		if (cell instanceof WorkflowElement) {
			Window parentW = getGraph().getEditor().getWindow();
			((WorkflowElement) cell).showPropertyDialog(parentW, getGraph());
			
			
			return true;
		}
		return false;
	}

	/**
	 * Creates the listener responsible for updating the selection based on
	 * mouse events.
	 */
	protected MouseListener createMouseListener() {
		return new PEMouseHandler();
	}

	/**
	 * Handles selection in a way that we expect.
	 */
	public class PEMouseHandler extends MouseHandler {
		public void mousePressed(MouseEvent e) {
			handler = null;
			if (!e.isConsumed() && graph.isEnabled()) {
				graph.requestFocus();
				int s = graph.getTolerance();
				// Rectangle r = graph.fromScreen(new Rectangle(e.getX()-s,
				// e.getY()-s, 2*s, 2*s));

				   Rectangle2D r = graph.fromScreen(//HM, JGraph3.4.1
			               GraphConstants.createRect(e.getX()-s, e.getY()-s, 2*s, 2*s));
				 CellView aa = focus;
				   focus = (focus != null && focus.intersects(graph.getGraphics(),
						r)) ? focus : null;
				   
				 Point2D point = graph.fromScreen(GraphConstants.createPoint(e.getPoint()));//HM, JGraph3.4.1
		            cell = graph.getNextViewAt(focus, point.getX(), point.getY());//HM, JGraph3.4.1
					
					//focus =null;
				// changed from original because of overlapping
				
				if (focus == null) {
				    cell = graph.getNextViewAt(focus, point.getX(), point.getY());//HM, JGraph3.4.1
					focus = cell;
				} else {
					cell = focus;
				}
				
				if (cell instanceof ParticipantView){
					//如果焦点在ParticipantView上则取其子节点中对应的PORT
					cell = graph.getNextViewAt(cell.getChildViews(),cell, point.getX(), point.getY());//HM, JGraph3.4.1
					 focus = cell;		
				}
				
				// added - if this is activity, set it to be the last child
				// of it's parent because of possible overlaping
				if (focus != null) {

					Object fcell = focus.getCell();
					if (fcell instanceof Activity) {
						DefaultMutableTreeNode child = (DefaultMutableTreeNode) fcell;
						DefaultMutableTreeNode parent = (DefaultMutableTreeNode) child
								.getParent();
						// this is security check (when we set up all things
						// this if statement could be removed because every
						// Activity should have it's parent
						if (parent != null) {
							parent.insert(child, parent.getChildCount() - 1);
							// must refresh child views to get it in a right
							// order
							// which affect painting and determining which cell
							// is
							// under mouse cursor
							((ParticipantView) focus.getParentView())
									.refreshChildViews();
						}
					}

					// graphView.toFront(new CellView[] {focus});
				}

				cancelEditing(graph);

				// selecting cell on mouse press
				if (cell != null && !graph.isCellSelected(cell.getCell())) {
					selectCellForEvent(cell.getCell(), e);
					canMouseReleaseSelectCell = false;
				}

				if (e.getClickCount() == graph.getEditClickCount()
						&& focus != null
						&& !SwingUtilities.isRightMouseButton(e)
						&& !(focus instanceof ParticipantView)) {
					// && focus.isLeaf()) {
					// Start Editing
					graph.startEditingAtCell(focus.getCell());
					e.consume();
					cell = null;
				} else if (!isToggleSelectionEvent(e)
						&& !isForceMarqueeEvent(e) && focus != null) {
					// Immediate Selection
					if (handle != null) {
						handle.mousePressed(e);
						handler = handle;
					}
				}
				// Marquee Selection
				
				else if (!isToggleSelectionEvent(e) || focus == null) {
					if (marquee != null) {
						marquee.mousePressed(e);
						// imeddiately clears selection when clicked on empty
						// area
						cell = graph.getNextViewAt(focus, point.getX(), point.getY());//HM, JGraph3.4.1
						focus = cell;
						if (focus == null) {						 
							Object[] cells = (new ArrayList()).toArray();
							selectCellsForEvent(cells, e);							
						}
						handler = marquee;
					}
				}
			
			if (cell != null) {
					Object object = cell.getCell();
					XMLUtil.setSelectCell(object);
					}		
			}
		}

		public void mouseDragged(MouseEvent e) {
			// added - if one of selected cell is Participant there must be no
			// dragging
			Object[] sc = graph.getSelectionCells();
			if (sc != null) {
				for (int i = 0; i < sc.length; i++) {
					if (sc[i] instanceof Participant) {
						e.consume();
						return;
					}
				}
			}

			try {
				autoscroll(graph, e.getPoint());
				if (handler == marquee) {
					marquee.mouseDragged(e);
				} else if (handler == null && !isEditing(graph)
						&& focus != null) {
					if (!graph.isCellSelected(focus.getCell())) {
						// removed from original
						// selectCellForEvent(focus.getCell(), e);
						cell = null;
					}
					if (handle != null) {
						handle.mousePressed(e);
					}
					handler = handle;
				}
				if (handle != null && handler == handle) {
					handle.mouseDragged(e);
				}
			} finally {
				// cell = null;
			}
		}

		public void mouseReleased(MouseEvent e) {
			try {
				if (e != null && !e.isConsumed()) {
					if (handler == marquee) {
						marquee.mouseReleased(e);
					} else if (handler == handle && handle != null) {
						handle.mouseReleased(e);
					}

					// something added and something removed to suite our needs
					if (!e.isConsumed() && focus != null
							&& !SwingUtilities.isRightMouseButton(e)) {
						if (canMouseReleaseSelectCell) {
							selectCellForEvent(focus.getCell(), e);
						}
					}
					canMouseReleaseSelectCell = true;
				}
			} finally {
				insertionLocation = null;
				handler = null;
				cell = null;
			}
		}

		/**
		 * Introduced to patch JGraph2.0 - it didn't set approprate cursor.
		 */
		public void mouseMoved(MouseEvent e) {
			if (graph != null && graph.isEnabled()) {
				if (marquee != null)
					marquee.mouseMoved(e);
				if (handle != null)
					handle.mouseMoved(e);
				if (!e.isConsumed())
					graph.setCursor(Cursor.getDefaultCursor());
			}
		}
	}

	/**
	 * Constructs the "root handle" for <code>context</code>.
	 * 
	 * @param context
	 *            reference to the context of the current selection.
	 */
	public CellHandle createHandle(GraphContext context) {
		if (context != null && !context.isEmpty() && graph.isEnabled())
			return new PERootHandle(context);
		return null;
	}

	/**
	 * Manages selection movement. It is adapted to suport proper undo in
	 * coordination with WorkflowManager class.
	 */
	public class PERootHandle extends RootHandle {
		/**
		 * Creates a root handle which contains handles for the given cells. The
		 * root handle and all its childs point to the specified JGraph
		 * instance. The root handle is responsible for dragging the selection.
		 */
		public PERootHandle(GraphContext ctx) {
			super(ctx);
		}

		public void mouseReleased(MouseEvent event) {
			if (event != null && !event.isConsumed()) {
				if (activeHandle != null) {
					activeHandle.mouseReleased(event);
					activeHandle = null;
				} else if (isMoving && !event.getPoint().equals(start)) {
					if (cachedBounds != null) {
						
						 int dx = event.getX()-(int)start.getX();//HM, JGraph3.4.1
		                  int dy = event.getY()-(int)start.getY();//HM, JGraph3.4.1
		                  Point2D tmp = graph.fromScreen(GraphConstants.createPoint(dx, dy));//HM, JGraph3.4.1
		                  GraphLayoutCache.translateViews(views, tmp.getX(), tmp.getY());//HM, JGraph3.4.1
					}
					 // Harald Meister: snap activities to grid if grid is enabled
		        
					if (BPDConfig.getInstance().getGridStatus() &&
		                   views[0] instanceof com.ds.bpm.bpd.graph.ActivityView           ){
		                  com.ds.bpm.bpd.graph.ActivityView view = (com.ds.bpm.bpd.graph.ActivityView)views[0];
		                  Rectangle2D rect = view.getBounds();//HM, JGraph3.4.1
		                  int dx = 0;
		                  int dy = 0;

		                  int gridsize = BPDConfig.getInstance().getGridSize();
		                  int deltax = (int)rect.getX() % gridsize;
		                  int deltay = (int)rect.getY() % gridsize;
		                  int halfgrid = gridsize / 2;
		                  if (deltax > halfgrid){
		                     dx += (gridsize - deltax);
		                  } else {
		                     dx -= deltax;
		                  }
		                  if (deltay > halfgrid){
		                     dy += (gridsize - deltay);
		                  } else {
		                     dy -= deltay;
		                  }
		                  Point2D tmp = graph.fromScreen(GraphConstants.createPoint(dx, dy));//HM, JGraph3.4.1
		                  GraphLayoutCache.translateViews(views, tmp.getX(), tmp.getY());//HM, JGraph3.4.1
		               }
		              
		               // Harald Meister

					CellView[] all = graphLayoutCache.getAllDescendants(views);

					if (event.isControlDown() && graph.isCloneable()) { // Clone
																		// Cells
						Object[] cells = graph.getDescendants(context
								.getCells());
						ConnectionSet cs = ConnectionSet.create(graphModel,
								cells, false);
						cs.addConnections(all);
						Map propertyMap = GraphConstants.createAttributes(all,
								null);
						insertCells(context.getCells(), propertyMap, cs, true,
								0, 0);
						// for now I can't allow distinction in case if it is
						// attributeStore or not
					} else if (graph.isMoveable()) { // Move Cells
						// if (!graphModel.isAttributeStore()) {
						// Map propertyMap =
						// GraphConstants.createPropertyMap(all,null);
						Map propertyMap = GraphConstants.createAttributes(all,
								null);
						WorkflowManager dm = getGraph().getWorkflowManager();
						dm.moveCellsAndArrangeParticipants(propertyMap);
						/*
						 * } else { Map propertyMap =
						 * GraphConstants.createPropertyMap(all,null);
						 * WorkflowManager dm=getGraph().getWorkflowManager();
						 * dm.moveCellsAndArrangeParticipants(propertyMap); }
						 */
					}
					event.consume();
				}
			}
			start = null;
		}

	}

	/**
	 * Returns a listener that can update the graph when the model changes.
	 */
	protected Observer createGraphViewObserver() {
		return new PEGraphViewObserver();
	}

	/**
	 * This class observes view changes and is adapted to disallow deselection
	 * of cells after dragging.
	 */
	public class PEGraphViewObserver extends GraphViewObserver {

		public void update(Observable o, Object arg) {
			super.update(o, arg);
			// do not allow "deselection" on mouse release because there was
			// dragging
			canMouseReleaseSelectCell = false;
		}
	}

	/**
	 * Creates an instance of TransferHandler. Used for subclassers to provide
	 * different TransferHandler.
	 */
	protected TransferHandler createTransferHandler() {
		return new PETransferHandler();
	}

	/**
	 * PETransferHandler that supports pasteAt action and properly cut action.
	 * The new class must have been written on the basis of class
	 * GraphTransferableHandler because of it's final method createTransferable
	 * which couldn't be overriden. This method had to be modified to forbid
	 * copying of Participants, Subflows and Transitions.
	 */
	public class PETransferHandler extends TransferHandler {
		/* Pointer to the last cells that were cut or pasted. */
		protected Object in, out;

		protected boolean isCut = false;

		/* How many times the last transferable was inserted. */
		protected int inCount = 0;

		public boolean canImport(JComponent comp, DataFlavor[] flavors) {
			return true;
		}

		// 创建copy对象
		protected final Transferable createTransferable(JComponent c) {
			if (c instanceof JGraph) {
				JGraph graph = (JGraph) c;
				Object[] cells = graphLayoutCache.order(graph
						.getSelectionCells());
				if (cells != null && cells.length > 0) {
					// removing everything but Manual, subflow and route
					// activity -
					// only they can be copied
					boolean dispMessage = false;
					Set cellsToCopy = new HashSet();
					for (int i = 0; i < cells.length; i++) {
						if (!(cells[i] instanceof Participant)
								&& !(cells[i] instanceof Start)
								&& !(cells[i] instanceof End)) {
							if (cells[i] instanceof Transition) {
								Transition t = (Transition) cells[i];
								boolean tFlag = true;
								// 没有连接到开始节点
								tFlag = tFlag
										&& !(t.getSourceActivity() instanceof Start);
								// 没有连接到结束节点
								tFlag = tFlag
										&& !(t.getTargetActivity() instanceof End);
								// 连接的源节点选中
								tFlag = tFlag
										&& Utils.isExistedInArray(cells, t
												.getSourceActivity());
								// 连接的目的节点选中
								tFlag = tFlag
										&& Utils.isExistedInArray(cells, t
												.getTargetActivity());
								if (tFlag) {
									cellsToCopy.add(cells[i]);
								}
							} else {
								cellsToCopy.add(cells[i]);
							}
						} else {
							if (!(cells[i] instanceof Participant))
								dispMessage = true;
						}
					}

					if (cellsToCopy.size() != cells.length) {
						// warning message is not displayed in a case of copying
						// transitions
						if (dispMessage) {
							String appTitle = BPD.getAppTitle();
							JOptionPane
									.showMessageDialog(
											getGraph().getEditor().getWindow(),
											ResourceManager
													.getLanguageDependentString("WarningOnlyManualSubflowAndAutoActivitiesCanBeCopied"),
											appTitle,
											JOptionPane.WARNING_MESSAGE);
							return null;
						}
						cells = cellsToCopy.toArray();
						if (cells.length == 0)
							return null;
					}
					  ParentMap pm = ParentMap.create(graphModel, cells, false, true);
					Object[] flat = graph.getDescendants(cells);
					// I wan't get bother with connections here, but will
					// stop it from inserting into a model in insertCells method
					ConnectionSet cs = ConnectionSet.create(graphModel, flat,
							false);
					// Map viewAttributes =
					// GraphConstants.createPropertyMap(flat,graphView);
					Map viewAttributes = GraphConstants.createAttributes(flat,
							graphLayoutCache);
					  Rectangle2D bounds = graph.getCellBounds((Object[])out);//HM, JGraph3.4.1
					out = cells;
				       return create(graph, cells, viewAttributes, bounds, cs, pm);
				}
			}
			return null;
		}

		 protected GraphTransferable create(
		         JGraph graph,
		         Object[] cells,
		         Map viewAttributes,
		         Rectangle2D bounds,//HM, JGraph3.4.1
		         ConnectionSet cs,
		         ParentMap pm) {
		         return new GraphTransferable(cells, viewAttributes, bounds, cs, pm);
		      }

		protected void exportDone(JComponent comp, Transferable data, int action) {
			if (comp instanceof JGraph && data instanceof GraphTransferable) {
				Object[] cells = ((GraphTransferable) data).getCells();
				JGraph graph = (JGraph) comp;
				Point p = insertionLocation;
				if (p == null && action == TransferHandler.MOVE)
					removeCells(graph, cells);
				else if (p != null && handle != null) {
					int mod = (action == TransferHandler.COPY) ? InputEvent.CTRL_MASK
							: 0;
					handle.mouseReleased(new MouseEvent(comp, 0, 0, mod, p.x,
							p.y, 1, false));
				}
				insertionLocation = null;
			}
		}

		public void exportToClipboard(JComponent compo, Clipboard clip,
				int action) {
			isCut = (action == TransferHandler.MOVE);
			super.exportToClipboard(compo, clip, action);
		}

		public int getSourceActions(JComponent c) {
			return COPY_OR_MOVE;
		}

		public boolean importData(JComponent comp, Transferable t) {
			try {
				if (comp instanceof JGraph) {
					JGraph graph = (JGraph) comp;
					if (t.isDataFlavorSupported(GraphTransferable.dataFlavor)) {
						Object obj = t
								.getTransferData(GraphTransferable.dataFlavor);
						GraphTransferable gt = (GraphTransferable) obj;
						if (out != gt.getCells() || insertionLocation == null)
							return handleInsert(graph, gt);
						return true;
					}
				}
			} catch (Exception ex) {
				ex.printStackTrace();
			} finally {
				isCut = false;
			}
			return false;
		}

		/**
		 * This method was changed to support pasteAt action.
		 */
		protected boolean handleInsert(JGraph graph, GraphTransferable t) {
			Object[] cells = t.getCells();
			boolean c = out != cells || !isCut;
			if (in != cells) {
				inCount = (c) ? 1 : 0;
			}
			in = cells;
		    int dx = inCount * (int)graph.getGridSize();//HM, JGraph3.4.1
	         int dy = inCount * (int)graph.getGridSize();//HM, JGraph3.4.1

			Map attributeMap = null;

			// changed to enable pasteAt action
			if (t.getBounds() != null
					&& ((insertionLocation != null) || (insertionPoint != null))) {
				Point insPoint = insertionLocation;
				if (insPoint == null) {
					insPoint = insertionPoint;
				}
				Point p = t.getBounds().getBounds().getLocation();//HM, JGraph3.4.1

				dx = insPoint.x - p.x;
				dy = insPoint.y - p.y;

				if (insertionPoint != null) {
					// translating cells at clipboard to new location
					  Rectangle rect = t.getBounds().getBounds();//HM, JGraph3.4.1
		               rect.translate(dx,dy);//HM, JGraph3.4.1
		               t.getBounds().setRect(rect);//HM, JGraph3.4.1

					// there is no need for further translation in insertCells
					// method
					dx = 0;
					dy = 0;
					// reseting counter
					inCount = 0;
				}
			}
			inCount++;
			if (cells == out || graph.isDropEnabled()) {
				if (attributeMap == null)
					attributeMap = t.getAttributeMap();
				insertCells(cells, attributeMap, t.getConnectionSet(), c, dx,
						dy);
				return true;
			}
			return false;
		}

		protected void removeCells(JGraph graph, Object[] cells) {
			WorkflowManager dm = getGraph().getWorkflowManager();
			dm.removeCellsAndArrangeParticipants(cells);
		}
	}

	/**
	 * Insert the specified cells into the model. If clone is true, the cells
	 * are cloned an all datastructures are updated to reference these clones.
	 * Clones are created using the GraphModel.clone(Object)-method. If cells
	 * are cloned, they are translated using the given amount. This method is
	 * modified from original to support pasteAt action, and to forbid pasting
	 * of Participants, Subflows and Transitions as well as to fix a bug which
	 * didn't clone cell's userObject properly.
	 */
	public void insertCells(Object[] cells, Map viewAttributeMap,
			ConnectionSet cs, boolean clone, int dx, int dy) {

		List insert = new ArrayList();
		// retreive workflow manager
		WorkflowManager wm = getGraph().getWorkflowManager();

		// retreive property object
		Object wp = getGraph().getPropertyObject();

		String appTitle = BPD.getAppTitle();

		// added to avoid cloning/pasting participants and transitions
		Set cellsToCloneOrPaste = new HashSet();
		boolean dispMessage = false;
		for (int i = 0; i < cells.length; i++) {
			if (!(cells[i] instanceof Participant)
					&& !(cells[i] instanceof Start)
					&& !(cells[i] instanceof End)) {
				// if this is not an activity from the same process, forbid
				// copying
				// (can't do cross-graph copy of activities)
				// 只允许相同应用下的流程拷贝
				boolean flag = cells[i] instanceof Transition;
				if (!flag) {
					WorkflowProcess wpForCell = ((com.ds.bpm.bpd.xml.activity.Activity) ((Activity) cells[i])
							.getUserObject()).getOwnerProcess();
					if (wpForCell == null) {
						return;
					} else {
						flag = wpForCell.getAppName().equals(
								((WorkflowProcess) wp).getAppName());
					}
				}
				if (!flag) {
					JOptionPane
							.showMessageDialog(
									getGraph().getEditor().getWindow(),
									ResourceManager
											.getLanguageDependentString("ErrorCrossGraphCopyIsForbidden"),
									appTitle, JOptionPane.ERROR_MESSAGE);
					return;
				} else {
					cellsToCloneOrPaste.add(cells[i]);
				}

			} else {
				if (!(cells[i] instanceof Participant))
					dispMessage = true;
			}
		}
		if (cellsToCloneOrPaste.size() != cells.length) {
			// warning message is displayed in case of copying participants but
			// not in a case of copying transitions
			if (dispMessage) {
				JOptionPane
						.showMessageDialog(
								getGraph().getEditor().getWindow(),
								ResourceManager
										.getLanguageDependentString("WarningOnlyManualSubflowAndAutoActivitiesCanBePastedOrCloned"),
								appTitle, JOptionPane.WARNING_MESSAGE);
			}
			cells = cellsToCloneOrPaste.toArray();
		}

		if (cellsToCloneOrPaste.size() > 0) {
			// I don't care if it is clonning or cell was cutted, I always
			// clone cells because otherwise, I wouldn't have correct undo
			Map cellMap = graph.cloneCells(cells);

			for (int i = 0; i < cells.length; i++) {
				if (cellMap.get(cells[i]) instanceof Transition) {
					Transition t = (Transition) cellMap.get(cells[i]);
					// 路由的开始节点
					Activity srcAct = ((Transition) cells[i])
							.getSourceActivity();
					// 路由的结束节点
					Activity destAct = ((Transition) cells[i])
							.getTargetActivity();
					com.ds.bpm.bpd.xml.elements.Transition tElem = (com.ds.bpm.bpd.xml.elements.Transition) ((com.ds.bpm.bpd.xml.elements.Transition) (t
							.getUserObject())).clone();
					tElem.setFrom((XMLElement) (((Activity) (cellMap
							.get(srcAct))).getUserObject()));
					tElem
							.setTo((XMLElement) (((Activity) (cellMap
									.get(destAct))).getUserObject()));
					t.setUserObject(tElem);
					insert.add(t);
				} else {
					insert.add(cellMap.get(cells[i]));
				}
			}
			cs = cs.clone(cellMap);

			viewAttributeMap = GraphConstants.replaceKeys(cellMap,
					viewAttributeMap);

			// if there was a cloning and model is attribute store,
			// must fix value attribute
			// if (clone && graphModel.isAttributeStore()) {
			if (clone) {
				Iterator it = viewAttributeMap.entrySet().iterator();
				while (it.hasNext()) {
					Map.Entry entry = (Map.Entry) it.next();
					Object userObject = ((DefaultMutableTreeNode) entry
							.getKey()).getUserObject();
					Map map = (Map) entry.getValue();
					GraphConstants.setValue(map, userObject);
				}
			}

			// moving pasted/cloned cells to new location if needed
			if (dx != 0 || dy != 0) {
				GraphConstants.translate(viewAttributeMap.values(), dx, dy);
			}

			// inserting pasted/cloned cells into model (finding it's parents
			// and arranging participants) this is the place where I avoided to
			// insert connection sets
			wm.insertCellsAndArrangeParticipants(insert.toArray(),
					viewAttributeMap, cs);
		}
	}

}

/* End of PEGraphUI.java */
